<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for participants StructType
 * @subpackage Structs
 */
class Participants extends AbstractStructBase
{
    /**
     * The participant
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ParticipantDto[]
     */
    public $participant;
    /**
     * Constructor method for participants
     * @uses Participants::setParticipant()
     * @param \StructType\ParticipantDto[] $participant
     */
    public function __construct(array $participant = array())
    {
        $this
            ->setParticipant($participant);
    }
    /**
     * Get participant value
     * @return \StructType\ParticipantDto[]|null
     */
    public function getParticipant()
    {
        return $this->participant;
    }
    /**
     * This method is responsible for validating the values passed to the setParticipant method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParticipant method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParticipantForArrayConstraintsFromSetParticipant(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $participantsParticipantItem) {
            // validation for constraint: itemType
            if (!$participantsParticipantItem instanceof \StructType\ParticipantDto) {
                $invalidValues[] = is_object($participantsParticipantItem) ? get_class($participantsParticipantItem) : sprintf('%s(%s)', gettype($participantsParticipantItem), var_export($participantsParticipantItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The participant property can only contain items of type \StructType\ParticipantDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set participant value
     * @throws \InvalidArgumentException
     * @param \StructType\ParticipantDto[] $participant
     * @return \StructType\Participants
     */
    public function setParticipant(array $participant = array())
    {
        // validation for constraint: array
        if ('' !== ($participantArrayErrorMessage = self::validateParticipantForArrayConstraintsFromSetParticipant($participant))) {
            throw new \InvalidArgumentException($participantArrayErrorMessage, __LINE__);
        }
        $this->participant = $participant;
        return $this;
    }
    /**
     * Add item to participant value
     * @throws \InvalidArgumentException
     * @param \StructType\ParticipantDto $item
     * @return \StructType\Participants
     */
    public function addToParticipant(\StructType\ParticipantDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ParticipantDto) {
            throw new \InvalidArgumentException(sprintf('The participant property can only contain items of type \StructType\ParticipantDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->participant[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Participants
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
