<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for markAsReadRequest StructType
 * @subpackage Structs
 */
class MarkAsReadRequest extends AbstractStructBase
{
    /**
     * The conversationId
     * @var string
     */
    public $conversationId;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * Constructor method for markAsReadRequest
     * @uses MarkAsReadRequest::setConversationId()
     * @uses MarkAsReadRequest::setLang()
     * @param string $conversationId
     * @param string $lang
     */
    public function __construct($conversationId = null, $lang = null)
    {
        $this
            ->setConversationId($conversationId)
            ->setLang($lang);
    }
    /**
     * Get conversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }
    /**
     * Set conversationId value
     * @param string $conversationId
     * @return \StructType\MarkAsReadRequest
     */
    public function setConversationId($conversationId = null)
    {
        // validation for constraint: string
        if (!is_null($conversationId) && !is_string($conversationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversationId, true), gettype($conversationId)), __LINE__);
        }
        $this->conversationId = $conversationId;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\MarkAsReadRequest
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarkAsReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
