<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteConversationsRequest StructType
 * @subpackage Structs
 */
class DeleteConversationsRequest extends AbstractStructBase
{
    /**
     * The conversationIds
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $conversationIds;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * Constructor method for deleteConversationsRequest
     * @uses DeleteConversationsRequest::setConversationIds()
     * @uses DeleteConversationsRequest::setLang()
     * @param string[] $conversationIds
     * @param string $lang
     */
    public function __construct(array $conversationIds = array(), $lang = null)
    {
        $this
            ->setConversationIds($conversationIds)
            ->setLang($lang);
    }
    /**
     * Get conversationIds value
     * @return string[]|null
     */
    public function getConversationIds()
    {
        return $this->conversationIds;
    }
    /**
     * This method is responsible for validating the values passed to the setConversationIds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConversationIds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConversationIdsForArrayConstraintsFromSetConversationIds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $deleteConversationsRequestConversationIdsItem) {
            // validation for constraint: itemType
            if (!is_string($deleteConversationsRequestConversationIdsItem)) {
                $invalidValues[] = is_object($deleteConversationsRequestConversationIdsItem) ? get_class($deleteConversationsRequestConversationIdsItem) : sprintf('%s(%s)', gettype($deleteConversationsRequestConversationIdsItem), var_export($deleteConversationsRequestConversationIdsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The conversationIds property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set conversationIds value
     * @throws \InvalidArgumentException
     * @param string[] $conversationIds
     * @return \StructType\DeleteConversationsRequest
     */
    public function setConversationIds(array $conversationIds = array())
    {
        // validation for constraint: array
        if ('' !== ($conversationIdsArrayErrorMessage = self::validateConversationIdsForArrayConstraintsFromSetConversationIds($conversationIds))) {
            throw new \InvalidArgumentException($conversationIdsArrayErrorMessage, __LINE__);
        }
        $this->conversationIds = $conversationIds;
        return $this;
    }
    /**
     * Add item to conversationIds value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DeleteConversationsRequest
     */
    public function addToConversationIds($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The conversationIds property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->conversationIds[] = $item;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\DeleteConversationsRequest
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteConversationsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
