<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for conversations StructType
 * @subpackage Structs
 */
class Conversations extends AbstractStructBase
{
    /**
     * The conversation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserConversationLoadingType[]
     */
    public $conversation;
    /**
     * Constructor method for conversations
     * @uses Conversations::setConversation()
     * @param \StructType\UserConversationLoadingType[] $conversation
     */
    public function __construct(array $conversation = array())
    {
        $this
            ->setConversation($conversation);
    }
    /**
     * Get conversation value
     * @return \StructType\UserConversationLoadingType[]|null
     */
    public function getConversation()
    {
        return $this->conversation;
    }
    /**
     * This method is responsible for validating the values passed to the setConversation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConversation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConversationForArrayConstraintsFromSetConversation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $conversationsConversationItem) {
            // validation for constraint: itemType
            if (!$conversationsConversationItem instanceof \StructType\UserConversationLoadingType) {
                $invalidValues[] = is_object($conversationsConversationItem) ? get_class($conversationsConversationItem) : sprintf('%s(%s)', gettype($conversationsConversationItem), var_export($conversationsConversationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The conversation property can only contain items of type \StructType\UserConversationLoadingType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set conversation value
     * @throws \InvalidArgumentException
     * @param \StructType\UserConversationLoadingType[] $conversation
     * @return \StructType\Conversations
     */
    public function setConversation(array $conversation = array())
    {
        // validation for constraint: array
        if ('' !== ($conversationArrayErrorMessage = self::validateConversationForArrayConstraintsFromSetConversation($conversation))) {
            throw new \InvalidArgumentException($conversationArrayErrorMessage, __LINE__);
        }
        $this->conversation = $conversation;
        return $this;
    }
    /**
     * Add item to conversation value
     * @throws \InvalidArgumentException
     * @param \StructType\UserConversationLoadingType $item
     * @return \StructType\Conversations
     */
    public function addToConversation(\StructType\UserConversationLoadingType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserConversationLoadingType) {
            throw new \InvalidArgumentException(sprintf('The conversation property can only contain items of type \StructType\UserConversationLoadingType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->conversation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Conversations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
