<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for putMessageRequest StructType
 * @subpackage Structs
 */
class PutMessageRequest extends AbstractStructBase
{
    /**
     * The conversationId
     * @var string
     */
    public $conversationId;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * The sendCopy
     * @var bool
     */
    public $sendCopy;
    /**
     * The lang
     * @var string
     */
    public $lang;
    /**
     * Constructor method for putMessageRequest
     * @uses PutMessageRequest::setConversationId()
     * @uses PutMessageRequest::setMessage()
     * @uses PutMessageRequest::setSendCopy()
     * @uses PutMessageRequest::setLang()
     * @param string $conversationId
     * @param string $message
     * @param bool $sendCopy
     * @param string $lang
     */
    public function __construct($conversationId = null, $message = null, $sendCopy = null, $lang = null)
    {
        $this
            ->setConversationId($conversationId)
            ->setMessage($message)
            ->setSendCopy($sendCopy)
            ->setLang($lang);
    }
    /**
     * Get conversationId value
     * @return string|null
     */
    public function getConversationId()
    {
        return $this->conversationId;
    }
    /**
     * Set conversationId value
     * @param string $conversationId
     * @return \StructType\PutMessageRequest
     */
    public function setConversationId($conversationId = null)
    {
        // validation for constraint: string
        if (!is_null($conversationId) && !is_string($conversationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conversationId, true), gettype($conversationId)), __LINE__);
        }
        $this->conversationId = $conversationId;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\PutMessageRequest
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get sendCopy value
     * @return bool|null
     */
    public function getSendCopy()
    {
        return $this->sendCopy;
    }
    /**
     * Set sendCopy value
     * @param bool $sendCopy
     * @return \StructType\PutMessageRequest
     */
    public function setSendCopy($sendCopy = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendCopy) && !is_bool($sendCopy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendCopy, true), gettype($sendCopy)), __LINE__);
        }
        $this->sendCopy = $sendCopy;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \StructType\PutMessageRequest
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lang, true), gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PutMessageRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
