<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Post ServiceType
 * @subpackage Services
 */
class Post extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named postConversation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $sessionId
     * @param \StructType\PostConversationRequest $postConversationRequest
     * @return \StructType\UserConversationPostingResponse|bool
     */
    public function postConversation($apiKey, $sign, $time, $sessionId, \StructType\PostConversationRequest $postConversationRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->postConversation($apiKey, $sign, $time, $sessionId, $postConversationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserConversationPostingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
