<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Mark ServiceType
 * @subpackage Services
 */
class Mark extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named markAsRead
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $sessionId
     * @param \StructType\MarkAsReadRequest $markAsReadRequest
     * @return \StructType\UserConversationMarkingReadResponse|bool
     */
    public function markAsRead($apiKey, $sign, $time, $sessionId, \StructType\MarkAsReadRequest $markAsReadRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->markAsRead($apiKey, $sign, $time, $sessionId, $markAsReadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named markAsUnread
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $apiKey
     * @param string $sign
     * @param string $time
     * @param string $sessionId
     * @param \StructType\MarkAsUnreadRequest $markAsUnreadRequest
     * @return \StructType\UserConversationMarkingReadResponse|bool
     */
    public function markAsUnread($apiKey, $sign, $time, $sessionId, \StructType\MarkAsUnreadRequest $markAsUnreadRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->markAsUnread($apiKey, $sign, $time, $sessionId, $markAsUnreadRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UserConversationMarkingReadResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
