<?php

namespace EnumType;

/**
 * This class stands for messageType EnumType
 * @subpackage Enumerations
 */
class MessageType
{
    /**
     * Constant for value 'USER'
     * @return string 'USER'
     */
    const VALUE_USER = 'USER';
    /**
     * Constant for value 'SYSTEM'
     * @return string 'SYSTEM'
     */
    const VALUE_SYSTEM = 'SYSTEM';
    /**
     * Constant for value 'ALL'
     * @return string 'ALL'
     */
    const VALUE_ALL = 'ALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_USER
     * @uses self::VALUE_SYSTEM
     * @uses self::VALUE_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_USER,
            self::VALUE_SYSTEM,
            self::VALUE_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
