<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleData StructType
 * @subpackage Structs
 */
class VehicleData extends AbstractStructBase
{
    /**
     * The vehicleCode
     * @var string
     */
    public $vehicleCode;
    /**
     * The brandCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $brandCode;
    /**
     * The modelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modelCode;
    /**
     * The price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $price;
    /**
     * The weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $weight;
    /**
     * The power
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $power;
    /**
     * The secureCodes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $secureCodes;
    /**
     * The seats
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $seats;
    /**
     * The fuel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fuel;
    /**
     * The vehicleUsage
     * @var string
     */
    public $vehicleUsage;
    /**
     * The registrationDate
     * @var string
     */
    public $registrationDate;
    /**
     * Constructor method for VehicleData
     * @uses VehicleData::setVehicleCode()
     * @uses VehicleData::setBrandCode()
     * @uses VehicleData::setModelCode()
     * @uses VehicleData::setPrice()
     * @uses VehicleData::setWeight()
     * @uses VehicleData::setPower()
     * @uses VehicleData::setSecureCodes()
     * @uses VehicleData::setSeats()
     * @uses VehicleData::setFuel()
     * @uses VehicleData::setVehicleUsage()
     * @uses VehicleData::setRegistrationDate()
     * @param string $vehicleCode
     * @param string $brandCode
     * @param string $modelCode
     * @param int $price
     * @param int $weight
     * @param int $power
     * @param string[] $secureCodes
     * @param int $seats
     * @param string $fuel
     * @param string $vehicleUsage
     * @param string $registrationDate
     */
    public function __construct($vehicleCode = null, $brandCode = null, $modelCode = null, $price = null, $weight = null, $power = null, array $secureCodes = array(), $seats = null, $fuel = null, $vehicleUsage = null, $registrationDate = null)
    {
        $this
            ->setVehicleCode($vehicleCode)
            ->setBrandCode($brandCode)
            ->setModelCode($modelCode)
            ->setPrice($price)
            ->setWeight($weight)
            ->setPower($power)
            ->setSecureCodes($secureCodes)
            ->setSeats($seats)
            ->setFuel($fuel)
            ->setVehicleUsage($vehicleUsage)
            ->setRegistrationDate($registrationDate);
    }
    /**
     * Get vehicleCode value
     * @return string|null
     */
    public function getVehicleCode()
    {
        return $this->vehicleCode;
    }
    /**
     * Set vehicleCode value
     * @param string $vehicleCode
     * @return \StructType\VehicleData
     */
    public function setVehicleCode($vehicleCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleCode) && !is_string($vehicleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleCode)), __LINE__);
        }
        $this->vehicleCode = $vehicleCode;
        return $this;
    }
    /**
     * Get brandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->brandCode;
    }
    /**
     * Set brandCode value
     * @param string $brandCode
     * @return \StructType\VehicleData
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandCode)), __LINE__);
        }
        $this->brandCode = $brandCode;
        return $this;
    }
    /**
     * Get modelCode value
     * @return string|null
     */
    public function getModelCode()
    {
        return $this->modelCode;
    }
    /**
     * Set modelCode value
     * @param string $modelCode
     * @return \StructType\VehicleData
     */
    public function setModelCode($modelCode = null)
    {
        // validation for constraint: string
        if (!is_null($modelCode) && !is_string($modelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelCode)), __LINE__);
        }
        $this->modelCode = $modelCode;
        return $this;
    }
    /**
     * Get price value
     * @return int|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param int $price
     * @return \StructType\VehicleData
     */
    public function setPrice($price = null)
    {
        // validation for constraint: int
        if (!is_null($price) && !is_numeric($price)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get weight value
     * @return int|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param int $weight
     * @return \StructType\VehicleData
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: int
        if (!is_null($weight) && !is_numeric($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get power value
     * @return int|null
     */
    public function getPower()
    {
        return $this->power;
    }
    /**
     * Set power value
     * @param int $power
     * @return \StructType\VehicleData
     */
    public function setPower($power = null)
    {
        // validation for constraint: int
        if (!is_null($power) && !is_numeric($power)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($power)), __LINE__);
        }
        $this->power = $power;
        return $this;
    }
    /**
     * Get secureCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSecureCodes()
    {
        return isset($this->secureCodes) ? $this->secureCodes : null;
    }
    /**
     * Set secureCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $secureCodes
     * @return \StructType\VehicleData
     */
    public function setSecureCodes(array $secureCodes = array())
    {
        foreach ($secureCodes as $vehicleDataSecureCodesItem) {
            // validation for constraint: itemType
            if (!is_string($vehicleDataSecureCodesItem)) {
                throw new \InvalidArgumentException(sprintf('The secureCodes property can only contain items of string, "%s" given', is_object($vehicleDataSecureCodesItem) ? get_class($vehicleDataSecureCodesItem) : gettype($vehicleDataSecureCodesItem)), __LINE__);
            }
        }
        if (is_null($secureCodes) || (is_array($secureCodes) && empty($secureCodes))) {
            unset($this->secureCodes);
        } else {
            $this->secureCodes = $secureCodes;
        }
        return $this;
    }
    /**
     * Add item to secureCodes value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleData
     */
    public function addToSecureCodes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The secureCodes property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->secureCodes[] = $item;
        return $this;
    }
    /**
     * Get seats value
     * @return int|null
     */
    public function getSeats()
    {
        return $this->seats;
    }
    /**
     * Set seats value
     * @param int $seats
     * @return \StructType\VehicleData
     */
    public function setSeats($seats = null)
    {
        // validation for constraint: int
        if (!is_null($seats) && !is_numeric($seats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($seats)), __LINE__);
        }
        $this->seats = $seats;
        return $this;
    }
    /**
     * Get fuel value
     * @return string|null
     */
    public function getFuel()
    {
        return $this->fuel;
    }
    /**
     * Set fuel value
     * @param string $fuel
     * @return \StructType\VehicleData
     */
    public function setFuel($fuel = null)
    {
        // validation for constraint: string
        if (!is_null($fuel) && !is_string($fuel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fuel)), __LINE__);
        }
        $this->fuel = $fuel;
        return $this;
    }
    /**
     * Get vehicleUsage value
     * @return string|null
     */
    public function getVehicleUsage()
    {
        return $this->vehicleUsage;
    }
    /**
     * Set vehicleUsage value
     * @param string $vehicleUsage
     * @return \StructType\VehicleData
     */
    public function setVehicleUsage($vehicleUsage = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleUsage) && !is_string($vehicleUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleUsage)), __LINE__);
        }
        $this->vehicleUsage = $vehicleUsage;
        return $this;
    }
    /**
     * Get registrationDate value
     * @return string|null
     */
    public function getRegistrationDate()
    {
        return $this->registrationDate;
    }
    /**
     * Set registrationDate value
     * @param string $registrationDate
     * @return \StructType\VehicleData
     */
    public function setRegistrationDate($registrationDate = null)
    {
        // validation for constraint: string
        if (!is_null($registrationDate) && !is_string($registrationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDate)), __LINE__);
        }
        $this->registrationDate = $registrationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
