<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tariff StructType
 * @subpackage Structs
 */
class Tariff extends AbstractStructBase
{
    /**
     * The tariffCode
     * @var string
     */
    public $tariffCode;
    /**
     * The limitCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $limitCode;
    /**
     * The multipleCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $multipleCode;
    /**
     * The participationRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $participationRate;
    /**
     * The variantCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $variantCode;
    /**
     * The free
     * @var bool
     */
    public $free;
    /**
     * Constructor method for Tariff
     * @uses Tariff::setTariffCode()
     * @uses Tariff::setLimitCode()
     * @uses Tariff::setMultipleCode()
     * @uses Tariff::setParticipationRate()
     * @uses Tariff::setVariantCode()
     * @uses Tariff::setFree()
     * @param string $tariffCode
     * @param string $limitCode
     * @param string $multipleCode
     * @param string $participationRate
     * @param string $variantCode
     * @param bool $free
     */
    public function __construct($tariffCode = null, $limitCode = null, $multipleCode = null, $participationRate = null, $variantCode = null, $free = null)
    {
        $this
            ->setTariffCode($tariffCode)
            ->setLimitCode($limitCode)
            ->setMultipleCode($multipleCode)
            ->setParticipationRate($participationRate)
            ->setVariantCode($variantCode)
            ->setFree($free);
    }
    /**
     * Get tariffCode value
     * @return string|null
     */
    public function getTariffCode()
    {
        return $this->tariffCode;
    }
    /**
     * Set tariffCode value
     * @param string $tariffCode
     * @return \StructType\Tariff
     */
    public function setTariffCode($tariffCode = null)
    {
        // validation for constraint: string
        if (!is_null($tariffCode) && !is_string($tariffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffCode)), __LINE__);
        }
        $this->tariffCode = $tariffCode;
        return $this;
    }
    /**
     * Get limitCode value
     * @return string|null
     */
    public function getLimitCode()
    {
        return $this->limitCode;
    }
    /**
     * Set limitCode value
     * @param string $limitCode
     * @return \StructType\Tariff
     */
    public function setLimitCode($limitCode = null)
    {
        // validation for constraint: string
        if (!is_null($limitCode) && !is_string($limitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($limitCode)), __LINE__);
        }
        $this->limitCode = $limitCode;
        return $this;
    }
    /**
     * Get multipleCode value
     * @return string|null
     */
    public function getMultipleCode()
    {
        return $this->multipleCode;
    }
    /**
     * Set multipleCode value
     * @param string $multipleCode
     * @return \StructType\Tariff
     */
    public function setMultipleCode($multipleCode = null)
    {
        // validation for constraint: string
        if (!is_null($multipleCode) && !is_string($multipleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($multipleCode)), __LINE__);
        }
        $this->multipleCode = $multipleCode;
        return $this;
    }
    /**
     * Get participationRate value
     * @return string|null
     */
    public function getParticipationRate()
    {
        return $this->participationRate;
    }
    /**
     * Set participationRate value
     * @param string $participationRate
     * @return \StructType\Tariff
     */
    public function setParticipationRate($participationRate = null)
    {
        // validation for constraint: string
        if (!is_null($participationRate) && !is_string($participationRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participationRate)), __LINE__);
        }
        $this->participationRate = $participationRate;
        return $this;
    }
    /**
     * Get variantCode value
     * @return string|null
     */
    public function getVariantCode()
    {
        return $this->variantCode;
    }
    /**
     * Set variantCode value
     * @param string $variantCode
     * @return \StructType\Tariff
     */
    public function setVariantCode($variantCode = null)
    {
        // validation for constraint: string
        if (!is_null($variantCode) && !is_string($variantCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($variantCode)), __LINE__);
        }
        $this->variantCode = $variantCode;
        return $this;
    }
    /**
     * Get free value
     * @return bool|null
     */
    public function getFree()
    {
        return $this->free;
    }
    /**
     * Set free value
     * @param bool $free
     * @return \StructType\Tariff
     */
    public function setFree($free = null)
    {
        $this->free = $free;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tariff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
