<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeriodPrice StructType
 * @subpackage Structs
 */
class PeriodPrice extends AbstractPeriodPrice
{
    /**
     * The paymentFrequency
     * @var string
     */
    public $paymentFrequency;
    /**
     * Constructor method for PeriodPrice
     * @uses PeriodPrice::setPaymentFrequency()
     * @param string $paymentFrequency
     */
    public function __construct($paymentFrequency = null)
    {
        $this
            ->setPaymentFrequency($paymentFrequency);
    }
    /**
     * Get paymentFrequency value
     * @return string|null
     */
    public function getPaymentFrequency()
    {
        return $this->paymentFrequency;
    }
    /**
     * Set paymentFrequency value
     * @param string $paymentFrequency
     * @return \StructType\PeriodPrice
     */
    public function setPaymentFrequency($paymentFrequency = null)
    {
        // validation for constraint: string
        if (!is_null($paymentFrequency) && !is_string($paymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentFrequency)), __LINE__);
        }
        $this->paymentFrequency = $paymentFrequency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PeriodPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
