<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsurancePackagePrices2 StructType
 * @subpackage Structs
 */
class InsurancePackagePrices2 extends AbstractInsurancePackagePrices
{
    /**
     * The periodPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PeriodPrice2[]
     */
    public $periodPrices;
    /**
     * Constructor method for InsurancePackagePrices2
     * @uses InsurancePackagePrices2::setPeriodPrices()
     * @param \StructType\PeriodPrice2[] $periodPrices
     */
    public function __construct(array $periodPrices = array())
    {
        $this
            ->setPeriodPrices($periodPrices);
    }
    /**
     * Get periodPrices value
     * @return \StructType\PeriodPrice2[]|null
     */
    public function getPeriodPrices()
    {
        return $this->periodPrices;
    }
    /**
     * Set periodPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\PeriodPrice2[] $periodPrices
     * @return \StructType\InsurancePackagePrices2
     */
    public function setPeriodPrices(array $periodPrices = array())
    {
        foreach ($periodPrices as $insurancePackagePrices2PeriodPricesItem) {
            // validation for constraint: itemType
            if (!$insurancePackagePrices2PeriodPricesItem instanceof \StructType\PeriodPrice2) {
                throw new \InvalidArgumentException(sprintf('The periodPrices property can only contain items of \StructType\PeriodPrice2, "%s" given', is_object($insurancePackagePrices2PeriodPricesItem) ? get_class($insurancePackagePrices2PeriodPricesItem) : gettype($insurancePackagePrices2PeriodPricesItem)), __LINE__);
            }
        }
        $this->periodPrices = $periodPrices;
        return $this;
    }
    /**
     * Add item to periodPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\PeriodPrice2 $item
     * @return \StructType\InsurancePackagePrices2
     */
    public function addToPeriodPrices(\StructType\PeriodPrice2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PeriodPrice2) {
            throw new \InvalidArgumentException(sprintf('The periodPrices property can only contain items of \StructType\PeriodPrice2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->periodPrices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsurancePackagePrices2
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
