<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsurancePackagePrices StructType
 * @subpackage Structs
 */
class InsurancePackagePrices extends AbstractInsurancePackagePrices
{
    /**
     * The periodPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\PeriodPrice[]
     */
    public $periodPrices;
    /**
     * Constructor method for InsurancePackagePrices
     * @uses InsurancePackagePrices::setPeriodPrices()
     * @param \StructType\PeriodPrice[] $periodPrices
     */
    public function __construct(array $periodPrices = array())
    {
        $this
            ->setPeriodPrices($periodPrices);
    }
    /**
     * Get periodPrices value
     * @return \StructType\PeriodPrice[]|null
     */
    public function getPeriodPrices()
    {
        return $this->periodPrices;
    }
    /**
     * Set periodPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\PeriodPrice[] $periodPrices
     * @return \StructType\InsurancePackagePrices
     */
    public function setPeriodPrices(array $periodPrices = array())
    {
        foreach ($periodPrices as $insurancePackagePricesPeriodPricesItem) {
            // validation for constraint: itemType
            if (!$insurancePackagePricesPeriodPricesItem instanceof \StructType\PeriodPrice) {
                throw new \InvalidArgumentException(sprintf('The periodPrices property can only contain items of \StructType\PeriodPrice, "%s" given', is_object($insurancePackagePricesPeriodPricesItem) ? get_class($insurancePackagePricesPeriodPricesItem) : gettype($insurancePackagePricesPeriodPricesItem)), __LINE__);
            }
        }
        $this->periodPrices = $periodPrices;
        return $this;
    }
    /**
     * Add item to periodPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\PeriodPrice $item
     * @return \StructType\InsurancePackagePrices
     */
    public function addToPeriodPrices(\StructType\PeriodPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PeriodPrice) {
            throw new \InvalidArgumentException(sprintf('The periodPrices property can only contain items of \StructType\PeriodPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->periodPrices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsurancePackagePrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
