<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculatePrices2Response StructType
 * @subpackage Structs
 */
class CalculatePrices2Response extends AbstractCalculatePricesResponse
{
    /**
     * The insurancePrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InsurancePackagePrices2[]
     */
    public $insurancePrices;
    /**
     * Constructor method for CalculatePrices2Response
     * @uses CalculatePrices2Response::setInsurancePrices()
     * @param \StructType\InsurancePackagePrices2[] $insurancePrices
     */
    public function __construct(array $insurancePrices = array())
    {
        $this
            ->setInsurancePrices($insurancePrices);
    }
    /**
     * Get insurancePrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InsurancePackagePrices2[]|null
     */
    public function getInsurancePrices()
    {
        return isset($this->insurancePrices) ? $this->insurancePrices : null;
    }
    /**
     * Set insurancePrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePackagePrices2[] $insurancePrices
     * @return \StructType\CalculatePrices2Response
     */
    public function setInsurancePrices(array $insurancePrices = array())
    {
        foreach ($insurancePrices as $calculatePrices2ResponseInsurancePricesItem) {
            // validation for constraint: itemType
            if (!$calculatePrices2ResponseInsurancePricesItem instanceof \StructType\InsurancePackagePrices2) {
                throw new \InvalidArgumentException(sprintf('The insurancePrices property can only contain items of \StructType\InsurancePackagePrices2, "%s" given', is_object($calculatePrices2ResponseInsurancePricesItem) ? get_class($calculatePrices2ResponseInsurancePricesItem) : gettype($calculatePrices2ResponseInsurancePricesItem)), __LINE__);
            }
        }
        if (is_null($insurancePrices) || (is_array($insurancePrices) && empty($insurancePrices))) {
            unset($this->insurancePrices);
        } else {
            $this->insurancePrices = $insurancePrices;
        }
        return $this;
    }
    /**
     * Add item to insurancePrices value
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePackagePrices2 $item
     * @return \StructType\CalculatePrices2Response
     */
    public function addToInsurancePrices(\StructType\InsurancePackagePrices2 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsurancePackagePrices2) {
            throw new \InvalidArgumentException(sprintf('The insurancePrices property can only contain items of \StructType\InsurancePackagePrices2, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->insurancePrices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalculatePrices2Response
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
