<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractPolicyData StructType
 * @subpackage Structs
 */
abstract class AbstractPolicyData extends AbstractStructBase
{
    /**
     * The startDate
     * @var string
     */
    public $startDate;
    /**
     * The ckpBonus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ckpBonus;
    /**
     * The ckpIncidentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ckpIncidentCount;
    /**
     * The ckpPartnerBonus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ckpPartnerBonus;
    /**
     * The ckpPartnerIncidentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ckpPartnerIncidentCount;
    /**
     * The manualInputDuration
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manualInputDuration;
    /**
     * The manualInputIncidentCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $manualInputIncidentCount;
    /**
     * The xsellPrp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $xsellPrp;
    /**
     * The xsellLif
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $xsellLif;
    /**
     * The xsellPf
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $xsellPf;
    /**
     * The voucher
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $voucher;
    /**
     * The unusedCarMonths
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unusedCarMonths;
    /**
     * Constructor method for AbstractPolicyData
     * @uses AbstractPolicyData::setStartDate()
     * @uses AbstractPolicyData::setCkpBonus()
     * @uses AbstractPolicyData::setCkpIncidentCount()
     * @uses AbstractPolicyData::setCkpPartnerBonus()
     * @uses AbstractPolicyData::setCkpPartnerIncidentCount()
     * @uses AbstractPolicyData::setManualInputDuration()
     * @uses AbstractPolicyData::setManualInputIncidentCount()
     * @uses AbstractPolicyData::setXsellPrp()
     * @uses AbstractPolicyData::setXsellLif()
     * @uses AbstractPolicyData::setXsellPf()
     * @uses AbstractPolicyData::setVoucher()
     * @uses AbstractPolicyData::setUnusedCarMonths()
     * @param string $startDate
     * @param int $ckpBonus
     * @param int $ckpIncidentCount
     * @param int $ckpPartnerBonus
     * @param int $ckpPartnerIncidentCount
     * @param int $manualInputDuration
     * @param int $manualInputIncidentCount
     * @param bool $xsellPrp
     * @param bool $xsellLif
     * @param bool $xsellPf
     * @param string $voucher
     * @param int $unusedCarMonths
     */
    public function __construct($startDate = null, $ckpBonus = null, $ckpIncidentCount = null, $ckpPartnerBonus = null, $ckpPartnerIncidentCount = null, $manualInputDuration = null, $manualInputIncidentCount = null, $xsellPrp = null, $xsellLif = null, $xsellPf = null, $voucher = null, $unusedCarMonths = null)
    {
        $this
            ->setStartDate($startDate)
            ->setCkpBonus($ckpBonus)
            ->setCkpIncidentCount($ckpIncidentCount)
            ->setCkpPartnerBonus($ckpPartnerBonus)
            ->setCkpPartnerIncidentCount($ckpPartnerIncidentCount)
            ->setManualInputDuration($manualInputDuration)
            ->setManualInputIncidentCount($manualInputIncidentCount)
            ->setXsellPrp($xsellPrp)
            ->setXsellLif($xsellLif)
            ->setXsellPf($xsellPf)
            ->setVoucher($voucher)
            ->setUnusedCarMonths($unusedCarMonths);
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\AbstractPolicyData
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get ckpBonus value
     * @return int|null
     */
    public function getCkpBonus()
    {
        return $this->ckpBonus;
    }
    /**
     * Set ckpBonus value
     * @param int $ckpBonus
     * @return \StructType\AbstractPolicyData
     */
    public function setCkpBonus($ckpBonus = null)
    {
        // validation for constraint: int
        if (!is_null($ckpBonus) && !is_numeric($ckpBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ckpBonus)), __LINE__);
        }
        $this->ckpBonus = $ckpBonus;
        return $this;
    }
    /**
     * Get ckpIncidentCount value
     * @return int|null
     */
    public function getCkpIncidentCount()
    {
        return $this->ckpIncidentCount;
    }
    /**
     * Set ckpIncidentCount value
     * @param int $ckpIncidentCount
     * @return \StructType\AbstractPolicyData
     */
    public function setCkpIncidentCount($ckpIncidentCount = null)
    {
        // validation for constraint: int
        if (!is_null($ckpIncidentCount) && !is_numeric($ckpIncidentCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ckpIncidentCount)), __LINE__);
        }
        $this->ckpIncidentCount = $ckpIncidentCount;
        return $this;
    }
    /**
     * Get ckpPartnerBonus value
     * @return int|null
     */
    public function getCkpPartnerBonus()
    {
        return $this->ckpPartnerBonus;
    }
    /**
     * Set ckpPartnerBonus value
     * @param int $ckpPartnerBonus
     * @return \StructType\AbstractPolicyData
     */
    public function setCkpPartnerBonus($ckpPartnerBonus = null)
    {
        // validation for constraint: int
        if (!is_null($ckpPartnerBonus) && !is_numeric($ckpPartnerBonus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ckpPartnerBonus)), __LINE__);
        }
        $this->ckpPartnerBonus = $ckpPartnerBonus;
        return $this;
    }
    /**
     * Get ckpPartnerIncidentCount value
     * @return int|null
     */
    public function getCkpPartnerIncidentCount()
    {
        return $this->ckpPartnerIncidentCount;
    }
    /**
     * Set ckpPartnerIncidentCount value
     * @param int $ckpPartnerIncidentCount
     * @return \StructType\AbstractPolicyData
     */
    public function setCkpPartnerIncidentCount($ckpPartnerIncidentCount = null)
    {
        // validation for constraint: int
        if (!is_null($ckpPartnerIncidentCount) && !is_numeric($ckpPartnerIncidentCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ckpPartnerIncidentCount)), __LINE__);
        }
        $this->ckpPartnerIncidentCount = $ckpPartnerIncidentCount;
        return $this;
    }
    /**
     * Get manualInputDuration value
     * @return int|null
     */
    public function getManualInputDuration()
    {
        return $this->manualInputDuration;
    }
    /**
     * Set manualInputDuration value
     * @param int $manualInputDuration
     * @return \StructType\AbstractPolicyData
     */
    public function setManualInputDuration($manualInputDuration = null)
    {
        // validation for constraint: int
        if (!is_null($manualInputDuration) && !is_numeric($manualInputDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manualInputDuration)), __LINE__);
        }
        $this->manualInputDuration = $manualInputDuration;
        return $this;
    }
    /**
     * Get manualInputIncidentCount value
     * @return int|null
     */
    public function getManualInputIncidentCount()
    {
        return $this->manualInputIncidentCount;
    }
    /**
     * Set manualInputIncidentCount value
     * @param int $manualInputIncidentCount
     * @return \StructType\AbstractPolicyData
     */
    public function setManualInputIncidentCount($manualInputIncidentCount = null)
    {
        // validation for constraint: int
        if (!is_null($manualInputIncidentCount) && !is_numeric($manualInputIncidentCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manualInputIncidentCount)), __LINE__);
        }
        $this->manualInputIncidentCount = $manualInputIncidentCount;
        return $this;
    }
    /**
     * Get xsellPrp value
     * @return bool|null
     */
    public function getXsellPrp()
    {
        return $this->xsellPrp;
    }
    /**
     * Set xsellPrp value
     * @param bool $xsellPrp
     * @return \StructType\AbstractPolicyData
     */
    public function setXsellPrp($xsellPrp = null)
    {
        $this->xsellPrp = $xsellPrp;
        return $this;
    }
    /**
     * Get xsellLif value
     * @return bool|null
     */
    public function getXsellLif()
    {
        return $this->xsellLif;
    }
    /**
     * Set xsellLif value
     * @param bool $xsellLif
     * @return \StructType\AbstractPolicyData
     */
    public function setXsellLif($xsellLif = null)
    {
        $this->xsellLif = $xsellLif;
        return $this;
    }
    /**
     * Get xsellPf value
     * @return bool|null
     */
    public function getXsellPf()
    {
        return $this->xsellPf;
    }
    /**
     * Set xsellPf value
     * @param bool $xsellPf
     * @return \StructType\AbstractPolicyData
     */
    public function setXsellPf($xsellPf = null)
    {
        $this->xsellPf = $xsellPf;
        return $this;
    }
    /**
     * Get voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->voucher;
    }
    /**
     * Set voucher value
     * @param string $voucher
     * @return \StructType\AbstractPolicyData
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voucher)), __LINE__);
        }
        $this->voucher = $voucher;
        return $this;
    }
    /**
     * Get unusedCarMonths value
     * @return int|null
     */
    public function getUnusedCarMonths()
    {
        return $this->unusedCarMonths;
    }
    /**
     * Set unusedCarMonths value
     * @param int $unusedCarMonths
     * @return \StructType\AbstractPolicyData
     */
    public function setUnusedCarMonths($unusedCarMonths = null)
    {
        // validation for constraint: int
        if (!is_null($unusedCarMonths) && !is_numeric($unusedCarMonths)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unusedCarMonths)), __LINE__);
        }
        $this->unusedCarMonths = $unusedCarMonths;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractPolicyData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
