<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractPeriodPrice StructType
 * @subpackage Structs
 */
abstract class AbstractPeriodPrice extends AbstractStructBase
{
    /**
     * The rateClass
     * @var string
     */
    public $rateClass;
    /**
     * The rateVersion
     * @var string
     */
    public $rateVersion;
    /**
     * The annualTotalBeforeDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $annualTotalBeforeDiscounts;
    /**
     * The periodTotalBeforeDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $periodTotalBeforeDiscounts;
    /**
     * The annualTotalAfterDiscounts
     * @var float
     */
    public $annualTotalAfterDiscounts;
    /**
     * The periodTotalAfterDiscounts
     * @var float
     */
    public $periodTotalAfterDiscounts;
    /**
     * The errorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The errorNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $errorNumber;
    /**
     * The tariffPrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TariffPrice[]
     */
    public $tariffPrices;
    /**
     * The tariffGroupDiscounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TariffGroupDiscount[]
     */
    public $tariffGroupDiscounts;
    /**
     * The contractDiscounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpusDiscount[]
     */
    public $contractDiscounts;
    /**
     * Constructor method for AbstractPeriodPrice
     * @uses AbstractPeriodPrice::setRateClass()
     * @uses AbstractPeriodPrice::setRateVersion()
     * @uses AbstractPeriodPrice::setAnnualTotalBeforeDiscounts()
     * @uses AbstractPeriodPrice::setPeriodTotalBeforeDiscounts()
     * @uses AbstractPeriodPrice::setAnnualTotalAfterDiscounts()
     * @uses AbstractPeriodPrice::setPeriodTotalAfterDiscounts()
     * @uses AbstractPeriodPrice::setErrorMessage()
     * @uses AbstractPeriodPrice::setErrorNumber()
     * @uses AbstractPeriodPrice::setTariffPrices()
     * @uses AbstractPeriodPrice::setTariffGroupDiscounts()
     * @uses AbstractPeriodPrice::setContractDiscounts()
     * @param string $rateClass
     * @param string $rateVersion
     * @param float $annualTotalBeforeDiscounts
     * @param float $periodTotalBeforeDiscounts
     * @param float $annualTotalAfterDiscounts
     * @param float $periodTotalAfterDiscounts
     * @param string $errorMessage
     * @param float $errorNumber
     * @param \StructType\TariffPrice[] $tariffPrices
     * @param \StructType\TariffGroupDiscount[] $tariffGroupDiscounts
     * @param \StructType\OpusDiscount[] $contractDiscounts
     */
    public function __construct($rateClass = null, $rateVersion = null, $annualTotalBeforeDiscounts = null, $periodTotalBeforeDiscounts = null, $annualTotalAfterDiscounts = null, $periodTotalAfterDiscounts = null, $errorMessage = null, $errorNumber = null, array $tariffPrices = array(), array $tariffGroupDiscounts = array(), array $contractDiscounts = array())
    {
        $this
            ->setRateClass($rateClass)
            ->setRateVersion($rateVersion)
            ->setAnnualTotalBeforeDiscounts($annualTotalBeforeDiscounts)
            ->setPeriodTotalBeforeDiscounts($periodTotalBeforeDiscounts)
            ->setAnnualTotalAfterDiscounts($annualTotalAfterDiscounts)
            ->setPeriodTotalAfterDiscounts($periodTotalAfterDiscounts)
            ->setErrorMessage($errorMessage)
            ->setErrorNumber($errorNumber)
            ->setTariffPrices($tariffPrices)
            ->setTariffGroupDiscounts($tariffGroupDiscounts)
            ->setContractDiscounts($contractDiscounts);
    }
    /**
     * Get rateClass value
     * @return string|null
     */
    public function getRateClass()
    {
        return $this->rateClass;
    }
    /**
     * Set rateClass value
     * @param string $rateClass
     * @return \StructType\AbstractPeriodPrice
     */
    public function setRateClass($rateClass = null)
    {
        // validation for constraint: string
        if (!is_null($rateClass) && !is_string($rateClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateClass)), __LINE__);
        }
        $this->rateClass = $rateClass;
        return $this;
    }
    /**
     * Get rateVersion value
     * @return string|null
     */
    public function getRateVersion()
    {
        return $this->rateVersion;
    }
    /**
     * Set rateVersion value
     * @param string $rateVersion
     * @return \StructType\AbstractPeriodPrice
     */
    public function setRateVersion($rateVersion = null)
    {
        // validation for constraint: string
        if (!is_null($rateVersion) && !is_string($rateVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateVersion)), __LINE__);
        }
        $this->rateVersion = $rateVersion;
        return $this;
    }
    /**
     * Get annualTotalBeforeDiscounts value
     * @return float|null
     */
    public function getAnnualTotalBeforeDiscounts()
    {
        return $this->annualTotalBeforeDiscounts;
    }
    /**
     * Set annualTotalBeforeDiscounts value
     * @param float $annualTotalBeforeDiscounts
     * @return \StructType\AbstractPeriodPrice
     */
    public function setAnnualTotalBeforeDiscounts($annualTotalBeforeDiscounts = null)
    {
        $this->annualTotalBeforeDiscounts = $annualTotalBeforeDiscounts;
        return $this;
    }
    /**
     * Get periodTotalBeforeDiscounts value
     * @return float|null
     */
    public function getPeriodTotalBeforeDiscounts()
    {
        return $this->periodTotalBeforeDiscounts;
    }
    /**
     * Set periodTotalBeforeDiscounts value
     * @param float $periodTotalBeforeDiscounts
     * @return \StructType\AbstractPeriodPrice
     */
    public function setPeriodTotalBeforeDiscounts($periodTotalBeforeDiscounts = null)
    {
        $this->periodTotalBeforeDiscounts = $periodTotalBeforeDiscounts;
        return $this;
    }
    /**
     * Get annualTotalAfterDiscounts value
     * @return float|null
     */
    public function getAnnualTotalAfterDiscounts()
    {
        return $this->annualTotalAfterDiscounts;
    }
    /**
     * Set annualTotalAfterDiscounts value
     * @param float $annualTotalAfterDiscounts
     * @return \StructType\AbstractPeriodPrice
     */
    public function setAnnualTotalAfterDiscounts($annualTotalAfterDiscounts = null)
    {
        $this->annualTotalAfterDiscounts = $annualTotalAfterDiscounts;
        return $this;
    }
    /**
     * Get periodTotalAfterDiscounts value
     * @return float|null
     */
    public function getPeriodTotalAfterDiscounts()
    {
        return $this->periodTotalAfterDiscounts;
    }
    /**
     * Set periodTotalAfterDiscounts value
     * @param float $periodTotalAfterDiscounts
     * @return \StructType\AbstractPeriodPrice
     */
    public function setPeriodTotalAfterDiscounts($periodTotalAfterDiscounts = null)
    {
        $this->periodTotalAfterDiscounts = $periodTotalAfterDiscounts;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \StructType\AbstractPeriodPrice
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get errorNumber value
     * @return float|null
     */
    public function getErrorNumber()
    {
        return $this->errorNumber;
    }
    /**
     * Set errorNumber value
     * @param float $errorNumber
     * @return \StructType\AbstractPeriodPrice
     */
    public function setErrorNumber($errorNumber = null)
    {
        $this->errorNumber = $errorNumber;
        return $this;
    }
    /**
     * Get tariffPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TariffPrice[]|null
     */
    public function getTariffPrices()
    {
        return isset($this->tariffPrices) ? $this->tariffPrices : null;
    }
    /**
     * Set tariffPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TariffPrice[] $tariffPrices
     * @return \StructType\AbstractPeriodPrice
     */
    public function setTariffPrices(array $tariffPrices = array())
    {
        foreach ($tariffPrices as $abstractPeriodPriceTariffPricesItem) {
            // validation for constraint: itemType
            if (!$abstractPeriodPriceTariffPricesItem instanceof \StructType\TariffPrice) {
                throw new \InvalidArgumentException(sprintf('The tariffPrices property can only contain items of \StructType\TariffPrice, "%s" given', is_object($abstractPeriodPriceTariffPricesItem) ? get_class($abstractPeriodPriceTariffPricesItem) : gettype($abstractPeriodPriceTariffPricesItem)), __LINE__);
            }
        }
        if (is_null($tariffPrices) || (is_array($tariffPrices) && empty($tariffPrices))) {
            unset($this->tariffPrices);
        } else {
            $this->tariffPrices = $tariffPrices;
        }
        return $this;
    }
    /**
     * Add item to tariffPrices value
     * @throws \InvalidArgumentException
     * @param \StructType\TariffPrice $item
     * @return \StructType\AbstractPeriodPrice
     */
    public function addToTariffPrices(\StructType\TariffPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TariffPrice) {
            throw new \InvalidArgumentException(sprintf('The tariffPrices property can only contain items of \StructType\TariffPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tariffPrices[] = $item;
        return $this;
    }
    /**
     * Get tariffGroupDiscounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TariffGroupDiscount[]|null
     */
    public function getTariffGroupDiscounts()
    {
        return isset($this->tariffGroupDiscounts) ? $this->tariffGroupDiscounts : null;
    }
    /**
     * Set tariffGroupDiscounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TariffGroupDiscount[] $tariffGroupDiscounts
     * @return \StructType\AbstractPeriodPrice
     */
    public function setTariffGroupDiscounts(array $tariffGroupDiscounts = array())
    {
        foreach ($tariffGroupDiscounts as $abstractPeriodPriceTariffGroupDiscountsItem) {
            // validation for constraint: itemType
            if (!$abstractPeriodPriceTariffGroupDiscountsItem instanceof \StructType\TariffGroupDiscount) {
                throw new \InvalidArgumentException(sprintf('The tariffGroupDiscounts property can only contain items of \StructType\TariffGroupDiscount, "%s" given', is_object($abstractPeriodPriceTariffGroupDiscountsItem) ? get_class($abstractPeriodPriceTariffGroupDiscountsItem) : gettype($abstractPeriodPriceTariffGroupDiscountsItem)), __LINE__);
            }
        }
        if (is_null($tariffGroupDiscounts) || (is_array($tariffGroupDiscounts) && empty($tariffGroupDiscounts))) {
            unset($this->tariffGroupDiscounts);
        } else {
            $this->tariffGroupDiscounts = $tariffGroupDiscounts;
        }
        return $this;
    }
    /**
     * Add item to tariffGroupDiscounts value
     * @throws \InvalidArgumentException
     * @param \StructType\TariffGroupDiscount $item
     * @return \StructType\AbstractPeriodPrice
     */
    public function addToTariffGroupDiscounts(\StructType\TariffGroupDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TariffGroupDiscount) {
            throw new \InvalidArgumentException(sprintf('The tariffGroupDiscounts property can only contain items of \StructType\TariffGroupDiscount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tariffGroupDiscounts[] = $item;
        return $this;
    }
    /**
     * Get contractDiscounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpusDiscount[]|null
     */
    public function getContractDiscounts()
    {
        return isset($this->contractDiscounts) ? $this->contractDiscounts : null;
    }
    /**
     * Set contractDiscounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpusDiscount[] $contractDiscounts
     * @return \StructType\AbstractPeriodPrice
     */
    public function setContractDiscounts(array $contractDiscounts = array())
    {
        foreach ($contractDiscounts as $abstractPeriodPriceContractDiscountsItem) {
            // validation for constraint: itemType
            if (!$abstractPeriodPriceContractDiscountsItem instanceof \StructType\OpusDiscount) {
                throw new \InvalidArgumentException(sprintf('The contractDiscounts property can only contain items of \StructType\OpusDiscount, "%s" given', is_object($abstractPeriodPriceContractDiscountsItem) ? get_class($abstractPeriodPriceContractDiscountsItem) : gettype($abstractPeriodPriceContractDiscountsItem)), __LINE__);
            }
        }
        if (is_null($contractDiscounts) || (is_array($contractDiscounts) && empty($contractDiscounts))) {
            unset($this->contractDiscounts);
        } else {
            $this->contractDiscounts = $contractDiscounts;
        }
        return $this;
    }
    /**
     * Add item to contractDiscounts value
     * @throws \InvalidArgumentException
     * @param \StructType\OpusDiscount $item
     * @return \StructType\AbstractPeriodPrice
     */
    public function addToContractDiscounts(\StructType\OpusDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpusDiscount) {
            throw new \InvalidArgumentException(sprintf('The contractDiscounts property can only contain items of \StructType\OpusDiscount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->contractDiscounts[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractPeriodPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
