<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractInsurancePackage StructType
 * @subpackage Structs
 */
abstract class AbstractInsurancePackage extends AbstractStructBase
{
    /**
     * The packageId
     * @var string
     */
    public $packageId;
    /**
     * The tariffs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Tariff[]
     */
    public $tariffs;
    /**
     * The applyContractualServiceDiscount
     * @var bool
     */
    public $applyContractualServiceDiscount;
    /**
     * The calculatePricesBeforeDiscounts
     * @var bool
     */
    public $calculatePricesBeforeDiscounts;
    /**
     * The calculateTariffGroupDiscounts
     * @var bool
     */
    public $calculateTariffGroupDiscounts;
    /**
     * Constructor method for AbstractInsurancePackage
     * @uses AbstractInsurancePackage::setPackageId()
     * @uses AbstractInsurancePackage::setTariffs()
     * @uses AbstractInsurancePackage::setApplyContractualServiceDiscount()
     * @uses AbstractInsurancePackage::setCalculatePricesBeforeDiscounts()
     * @uses AbstractInsurancePackage::setCalculateTariffGroupDiscounts()
     * @param string $packageId
     * @param \StructType\Tariff[] $tariffs
     * @param bool $applyContractualServiceDiscount
     * @param bool $calculatePricesBeforeDiscounts
     * @param bool $calculateTariffGroupDiscounts
     */
    public function __construct($packageId = null, array $tariffs = array(), $applyContractualServiceDiscount = null, $calculatePricesBeforeDiscounts = null, $calculateTariffGroupDiscounts = null)
    {
        $this
            ->setPackageId($packageId)
            ->setTariffs($tariffs)
            ->setApplyContractualServiceDiscount($applyContractualServiceDiscount)
            ->setCalculatePricesBeforeDiscounts($calculatePricesBeforeDiscounts)
            ->setCalculateTariffGroupDiscounts($calculateTariffGroupDiscounts);
    }
    /**
     * Get packageId value
     * @return string|null
     */
    public function getPackageId()
    {
        return $this->packageId;
    }
    /**
     * Set packageId value
     * @param string $packageId
     * @return \StructType\AbstractInsurancePackage
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageId)), __LINE__);
        }
        $this->packageId = $packageId;
        return $this;
    }
    /**
     * Get tariffs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Tariff[]|null
     */
    public function getTariffs()
    {
        return isset($this->tariffs) ? $this->tariffs : null;
    }
    /**
     * Set tariffs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tariff[] $tariffs
     * @return \StructType\AbstractInsurancePackage
     */
    public function setTariffs(array $tariffs = array())
    {
        foreach ($tariffs as $abstractInsurancePackageTariffsItem) {
            // validation for constraint: itemType
            if (!$abstractInsurancePackageTariffsItem instanceof \StructType\Tariff) {
                throw new \InvalidArgumentException(sprintf('The tariffs property can only contain items of \StructType\Tariff, "%s" given', is_object($abstractInsurancePackageTariffsItem) ? get_class($abstractInsurancePackageTariffsItem) : gettype($abstractInsurancePackageTariffsItem)), __LINE__);
            }
        }
        if (is_null($tariffs) || (is_array($tariffs) && empty($tariffs))) {
            unset($this->tariffs);
        } else {
            $this->tariffs = $tariffs;
        }
        return $this;
    }
    /**
     * Add item to tariffs value
     * @throws \InvalidArgumentException
     * @param \StructType\Tariff $item
     * @return \StructType\AbstractInsurancePackage
     */
    public function addToTariffs(\StructType\Tariff $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tariff) {
            throw new \InvalidArgumentException(sprintf('The tariffs property can only contain items of \StructType\Tariff, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tariffs[] = $item;
        return $this;
    }
    /**
     * Get applyContractualServiceDiscount value
     * @return bool|null
     */
    public function getApplyContractualServiceDiscount()
    {
        return $this->applyContractualServiceDiscount;
    }
    /**
     * Set applyContractualServiceDiscount value
     * @param bool $applyContractualServiceDiscount
     * @return \StructType\AbstractInsurancePackage
     */
    public function setApplyContractualServiceDiscount($applyContractualServiceDiscount = null)
    {
        $this->applyContractualServiceDiscount = $applyContractualServiceDiscount;
        return $this;
    }
    /**
     * Get calculatePricesBeforeDiscounts value
     * @return bool|null
     */
    public function getCalculatePricesBeforeDiscounts()
    {
        return $this->calculatePricesBeforeDiscounts;
    }
    /**
     * Set calculatePricesBeforeDiscounts value
     * @param bool $calculatePricesBeforeDiscounts
     * @return \StructType\AbstractInsurancePackage
     */
    public function setCalculatePricesBeforeDiscounts($calculatePricesBeforeDiscounts = null)
    {
        $this->calculatePricesBeforeDiscounts = $calculatePricesBeforeDiscounts;
        return $this;
    }
    /**
     * Get calculateTariffGroupDiscounts value
     * @return bool|null
     */
    public function getCalculateTariffGroupDiscounts()
    {
        return $this->calculateTariffGroupDiscounts;
    }
    /**
     * Set calculateTariffGroupDiscounts value
     * @param bool $calculateTariffGroupDiscounts
     * @return \StructType\AbstractInsurancePackage
     */
    public function setCalculateTariffGroupDiscounts($calculateTariffGroupDiscounts = null)
    {
        $this->calculateTariffGroupDiscounts = $calculateTariffGroupDiscounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractInsurancePackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
