<?php

namespace EnumType;

/**
 * This class stands for VehicleUsage EnumType
 * @subpackage Enumerations
 */
class VehicleUsage
{
    /**
     * Constant for value 'COMMON'
     * @return string 'COMMON'
     */
    const VALUE_COMMON = 'COMMON';
    /**
     * Constant for value 'TAXI'
     * @return string 'TAXI'
     */
    const VALUE_TAXI = 'TAXI';
    /**
     * Constant for value 'RENTAL'
     * @return string 'RENTAL'
     */
    const VALUE_RENTAL = 'RENTAL';
    /**
     * Constant for value 'DRIVING_SCHOOL'
     * @return string 'DRIVING_SCHOOL'
     */
    const VALUE_DRIVING_SCHOOL = 'DRIVING_SCHOOL';
    /**
     * Constant for value 'DANGEROUS_TRANSPORT'
     * @return string 'DANGEROUS_TRANSPORT'
     */
    const VALUE_DANGEROUS_TRANSPORT = 'DANGEROUS_TRANSPORT';
    /**
     * Constant for value 'COURIER_SERVICE'
     * @return string 'COURIER_SERVICE'
     */
    const VALUE_COURIER_SERVICE = 'COURIER_SERVICE';
    /**
     * Constant for value 'VETERAN'
     * @return string 'VETERAN'
     */
    const VALUE_VETERAN = 'VETERAN';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_COMMON
     * @uses self::VALUE_TAXI
     * @uses self::VALUE_RENTAL
     * @uses self::VALUE_DRIVING_SCHOOL
     * @uses self::VALUE_DANGEROUS_TRANSPORT
     * @uses self::VALUE_COURIER_SERVICE
     * @uses self::VALUE_VETERAN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_COMMON,
            self::VALUE_TAXI,
            self::VALUE_RENTAL,
            self::VALUE_DRIVING_SCHOOL,
            self::VALUE_DANGEROUS_TRANSPORT,
            self::VALUE_COURIER_SERVICE,
            self::VALUE_VETERAN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
