<?php

namespace EnumType;

/**
 * This class stands for VehicleSecureCode EnumType
 * @subpackage Enumerations
 */
class VehicleSecureCode
{
    /**
     * Constant for value 'GEAR_SHIFT_LOCK'
     * @return string 'GEAR_SHIFT_LOCK'
     */
    const VALUE_GEAR_SHIFT_LOCK = 'GEAR_SHIFT_LOCK';
    /**
     * Constant for value 'CAR_LOCATOR'
     * @return string 'CAR_LOCATOR'
     */
    const VALUE_CAR_LOCATOR = 'CAR_LOCATOR';
    /**
     * Constant for value 'WINDOWS_VIN_ETCHED'
     * @return string 'WINDOWS_VIN_ETCHED'
     */
    const VALUE_WINDOWS_VIN_ETCHED = 'WINDOWS_VIN_ETCHED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GEAR_SHIFT_LOCK
     * @uses self::VALUE_CAR_LOCATOR
     * @uses self::VALUE_WINDOWS_VIN_ETCHED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GEAR_SHIFT_LOCK,
            self::VALUE_CAR_LOCATOR,
            self::VALUE_WINDOWS_VIN_ETCHED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
