<?php

namespace EnumType;

/**
 * This class stands for VehicleCode EnumType
 * @subpackage Enumerations
 */
class VehicleCode
{
    /**
     * Constant for value 'MO1'
     * @return string 'MO1'
     */
    const VALUE_MO_1 = 'MO1';
    /**
     * Constant for value 'MO2A'
     * @return string 'MO2A'
     */
    const VALUE_MO_2_A = 'MO2A';
    /**
     * Constant for value 'MO2B'
     * @return string 'MO2B'
     */
    const VALUE_MO_2_B = 'MO2B';
    /**
     * Constant for value 'MO3'
     * @return string 'MO3'
     */
    const VALUE_MO_3 = 'MO3';
    /**
     * Constant for value 'MO4'
     * @return string 'MO4'
     */
    const VALUE_MO_4 = 'MO4';
    /**
     * Constant for value 'OA1'
     * @return string 'OA1'
     */
    const VALUE_OA_1 = 'OA1';
    /**
     * Constant for value 'OA2A'
     * @return string 'OA2A'
     */
    const VALUE_OA_2_A = 'OA2A';
    /**
     * Constant for value 'OA2B'
     * @return string 'OA2B'
     */
    const VALUE_OA_2_B = 'OA2B';
    /**
     * Constant for value 'OA3A'
     * @return string 'OA3A'
     */
    const VALUE_OA_3_A = 'OA3A';
    /**
     * Constant for value 'OA3B'
     * @return string 'OA3B'
     */
    const VALUE_OA_3_B = 'OA3B';
    /**
     * Constant for value 'OA4A'
     * @return string 'OA4A'
     */
    const VALUE_OA_4_A = 'OA4A';
    /**
     * Constant for value 'OA4B'
     * @return string 'OA4B'
     */
    const VALUE_OA_4_B = 'OA4B';
    /**
     * Constant for value 'OA5'
     * @return string 'OA5'
     */
    const VALUE_OA_5 = 'OA5';
    /**
     * Constant for value 'OBYA'
     * @return string 'OBYA'
     */
    const VALUE_OBYA = 'OBYA';
    /**
     * Constant for value 'OBYB'
     * @return string 'OBYB'
     */
    const VALUE_OBYB = 'OBYB';
    /**
     * Constant for value 'SAN'
     * @return string 'SAN'
     */
    const VALUE_SAN = 'SAN';
    /**
     * Constant for value 'TAH'
     * @return string 'TAH'
     */
    const VALUE_TAH = 'TAH';
    /**
     * Constant for value 'NA2'
     * @return string 'NA2'
     */
    const VALUE_NA_2 = 'NA2';
    /**
     * Constant for value 'NA3'
     * @return string 'NA3'
     */
    const VALUE_NA_3 = 'NA3';
    /**
     * Constant for value 'SPS1'
     * @return string 'SPS1'
     */
    const VALUE_SPS_1 = 'SPS1';
    /**
     * Constant for value 'SPS2'
     * @return string 'SPS2'
     */
    const VALUE_SPS_2 = 'SPS2';
    /**
     * Constant for value 'SPS3'
     * @return string 'SPS3'
     */
    const VALUE_SPS_3 = 'SPS3';
    /**
     * Constant for value 'TRAA'
     * @return string 'TRAA'
     */
    const VALUE_TRAA = 'TRAA';
    /**
     * Constant for value 'TRAB'
     * @return string 'TRAB'
     */
    const VALUE_TRAB = 'TRAB';
    /**
     * Constant for value 'VZV'
     * @return string 'VZV'
     */
    const VALUE_VZV = 'VZV';
    /**
     * Constant for value 'ABM'
     * @return string 'ABM'
     */
    const VALUE_ABM = 'ABM';
    /**
     * Constant for value 'TBM'
     * @return string 'TBM'
     */
    const VALUE_TBM = 'TBM';
    /**
     * Constant for value 'AB1A'
     * @return string 'AB1A'
     */
    const VALUE_AB_1_A = 'AB1A';
    /**
     * Constant for value 'AB1B'
     * @return string 'AB1B'
     */
    const VALUE_AB_1_B = 'AB1B';
    /**
     * Constant for value 'AB2'
     * @return string 'AB2'
     */
    const VALUE_AB_2 = 'AB2';
    /**
     * Constant for value 'PV1'
     * @return string 'PV1'
     */
    const VALUE_PV_1 = 'PV1';
    /**
     * Constant for value 'PV2A'
     * @return string 'PV2A'
     */
    const VALUE_PV_2_A = 'PV2A';
    /**
     * Constant for value 'PV2B'
     * @return string 'PV2B'
     */
    const VALUE_PV_2_B = 'PV2B';
    /**
     * Constant for value 'PV2C'
     * @return string 'PV2C'
     */
    const VALUE_PV_2_C = 'PV2C';
    /**
     * Constant for value 'PV3'
     * @return string 'PV3'
     */
    const VALUE_PV_3 = 'PV3';
    /**
     * Constant for value 'CTKOL1'
     * @return string 'CTKOL1'
     */
    const VALUE_CTKOL_1 = 'CTKOL1';
    /**
     * Constant for value 'CTKOL2'
     * @return string 'CTKOL2'
     */
    const VALUE_CTKOL_2 = 'CTKOL2';
    /**
     * Constant for value 'CTKOL3'
     * @return string 'CTKOL3'
     */
    const VALUE_CTKOL_3 = 'CTKOL3';
    /**
     * Constant for value 'CTKOL4'
     * @return string 'CTKOL4'
     */
    const VALUE_CTKOL_4 = 'CTKOL4';
    /**
     * Constant for value 'CTKOL5'
     * @return string 'CTKOL5'
     */
    const VALUE_CTKOL_5 = 'CTKOL5';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MO_1
     * @uses self::VALUE_MO_2_A
     * @uses self::VALUE_MO_2_B
     * @uses self::VALUE_MO_3
     * @uses self::VALUE_MO_4
     * @uses self::VALUE_OA_1
     * @uses self::VALUE_OA_2_A
     * @uses self::VALUE_OA_2_B
     * @uses self::VALUE_OA_3_A
     * @uses self::VALUE_OA_3_B
     * @uses self::VALUE_OA_4_A
     * @uses self::VALUE_OA_4_B
     * @uses self::VALUE_OA_5
     * @uses self::VALUE_OBYA
     * @uses self::VALUE_OBYB
     * @uses self::VALUE_SAN
     * @uses self::VALUE_TAH
     * @uses self::VALUE_NA_2
     * @uses self::VALUE_NA_3
     * @uses self::VALUE_SPS_1
     * @uses self::VALUE_SPS_2
     * @uses self::VALUE_SPS_3
     * @uses self::VALUE_TRAA
     * @uses self::VALUE_TRAB
     * @uses self::VALUE_VZV
     * @uses self::VALUE_ABM
     * @uses self::VALUE_TBM
     * @uses self::VALUE_AB_1_A
     * @uses self::VALUE_AB_1_B
     * @uses self::VALUE_AB_2
     * @uses self::VALUE_PV_1
     * @uses self::VALUE_PV_2_A
     * @uses self::VALUE_PV_2_B
     * @uses self::VALUE_PV_2_C
     * @uses self::VALUE_PV_3
     * @uses self::VALUE_CTKOL_1
     * @uses self::VALUE_CTKOL_2
     * @uses self::VALUE_CTKOL_3
     * @uses self::VALUE_CTKOL_4
     * @uses self::VALUE_CTKOL_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MO_1,
            self::VALUE_MO_2_A,
            self::VALUE_MO_2_B,
            self::VALUE_MO_3,
            self::VALUE_MO_4,
            self::VALUE_OA_1,
            self::VALUE_OA_2_A,
            self::VALUE_OA_2_B,
            self::VALUE_OA_3_A,
            self::VALUE_OA_3_B,
            self::VALUE_OA_4_A,
            self::VALUE_OA_4_B,
            self::VALUE_OA_5,
            self::VALUE_OBYA,
            self::VALUE_OBYB,
            self::VALUE_SAN,
            self::VALUE_TAH,
            self::VALUE_NA_2,
            self::VALUE_NA_3,
            self::VALUE_SPS_1,
            self::VALUE_SPS_2,
            self::VALUE_SPS_3,
            self::VALUE_TRAA,
            self::VALUE_TRAB,
            self::VALUE_VZV,
            self::VALUE_ABM,
            self::VALUE_TBM,
            self::VALUE_AB_1_A,
            self::VALUE_AB_1_B,
            self::VALUE_AB_2,
            self::VALUE_PV_1,
            self::VALUE_PV_2_A,
            self::VALUE_PV_2_B,
            self::VALUE_PV_2_C,
            self::VALUE_PV_3,
            self::VALUE_CTKOL_1,
            self::VALUE_CTKOL_2,
            self::VALUE_CTKOL_3,
            self::VALUE_CTKOL_4,
            self::VALUE_CTKOL_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
