<?php

namespace EnumType;

/**
 * This class stands for TariffVariantCode EnumType
 * @subpackage Enumerations
 */
class TariffVariantCode
{
    /**
     * Constant for value 'ASISTENCE_PLUS_STANDARD'
     * @return string 'ASISTENCE_PLUS_STANDARD'
     */
    const VALUE_ASISTENCE_PLUS_STANDARD = 'ASISTENCE_PLUS_STANDARD';
    /**
     * Constant for value 'ASISTENCE_PLUS_MAXI'
     * @return string 'ASISTENCE_PLUS_MAXI'
     */
    const VALUE_ASISTENCE_PLUS_MAXI = 'ASISTENCE_PLUS_MAXI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ASISTENCE_PLUS_STANDARD
     * @uses self::VALUE_ASISTENCE_PLUS_MAXI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ASISTENCE_PLUS_STANDARD,
            self::VALUE_ASISTENCE_PLUS_MAXI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
