<?php

namespace EnumType;

/**
 * This class stands for TariffMultipleCode EnumType
 * @subpackage Enumerations
 */
class TariffMultipleCode
{
    /**
     * Constant for value 'M_1'
     * @return string 'M_1'
     */
    const VALUE_M_1 = 'M_1';
    /**
     * Constant for value 'M_2'
     * @return string 'M_2'
     */
    const VALUE_M_2 = 'M_2';
    /**
     * Constant for value 'M_3'
     * @return string 'M_3'
     */
    const VALUE_M_3 = 'M_3';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_M_1
     * @uses self::VALUE_M_2
     * @uses self::VALUE_M_3
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_M_1,
            self::VALUE_M_2,
            self::VALUE_M_3,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
