<?php

namespace EnumType;

/**
 * This class stands for TariffGroup EnumType
 * @subpackage Enumerations
 */
class TariffGroup
{
    /**
     * Constant for value 'THIRD_PARTY'
     * @return string 'THIRD_PARTY'
     */
    const VALUE_THIRD_PARTY = 'THIRD_PARTY';
    /**
     * Constant for value 'COLLISION_DAMAGE'
     * @return string 'COLLISION_DAMAGE'
     */
    const VALUE_COLLISION_DAMAGE = 'COLLISION_DAMAGE';
    /**
     * Constant for value 'GLASS_BREAK'
     * @return string 'GLASS_BREAK'
     */
    const VALUE_GLASS_BREAK = 'GLASS_BREAK';
    /**
     * Constant for value 'ASSISTANCE'
     * @return string 'ASSISTANCE'
     */
    const VALUE_ASSISTANCE = 'ASSISTANCE';
    /**
     * Constant for value 'INJURY'
     * @return string 'INJURY'
     */
    const VALUE_INJURY = 'INJURY';
    /**
     * Constant for value 'LUGGAGE'
     * @return string 'LUGGAGE'
     */
    const VALUE_LUGGAGE = 'LUGGAGE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_THIRD_PARTY
     * @uses self::VALUE_COLLISION_DAMAGE
     * @uses self::VALUE_GLASS_BREAK
     * @uses self::VALUE_ASSISTANCE
     * @uses self::VALUE_INJURY
     * @uses self::VALUE_LUGGAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_THIRD_PARTY,
            self::VALUE_COLLISION_DAMAGE,
            self::VALUE_GLASS_BREAK,
            self::VALUE_ASSISTANCE,
            self::VALUE_INJURY,
            self::VALUE_LUGGAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
