<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TariffPrice StructType
 * @subpackage Structs
 */
class TariffPrice extends AbstractStructBase
{
    /**
     * The tariffCode
     * @var string
     */
    public $tariffCode;
    /**
     * The annualBeforeDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $annualBeforeDiscounts;
    /**
     * The periodBeforeDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $periodBeforeDiscounts;
    /**
     * The annualAfterDiscounts
     * @var float
     */
    public $annualAfterDiscounts;
    /**
     * The periodAfterDiscounts
     * @var float
     */
    public $periodAfterDiscounts;
    /**
     * The tariffCoefsBeforeDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tariffCoefsBeforeDiscounts;
    /**
     * The tariffCoefsAfterDiscounts
     * @var string
     */
    public $tariffCoefsAfterDiscounts;
    /**
     * The tariffDiscounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpusDiscount[]
     */
    public $tariffDiscounts;
    /**
     * Constructor method for TariffPrice
     * @uses TariffPrice::setTariffCode()
     * @uses TariffPrice::setAnnualBeforeDiscounts()
     * @uses TariffPrice::setPeriodBeforeDiscounts()
     * @uses TariffPrice::setAnnualAfterDiscounts()
     * @uses TariffPrice::setPeriodAfterDiscounts()
     * @uses TariffPrice::setTariffCoefsBeforeDiscounts()
     * @uses TariffPrice::setTariffCoefsAfterDiscounts()
     * @uses TariffPrice::setTariffDiscounts()
     * @param string $tariffCode
     * @param float $annualBeforeDiscounts
     * @param float $periodBeforeDiscounts
     * @param float $annualAfterDiscounts
     * @param float $periodAfterDiscounts
     * @param string $tariffCoefsBeforeDiscounts
     * @param string $tariffCoefsAfterDiscounts
     * @param \StructType\OpusDiscount[] $tariffDiscounts
     */
    public function __construct($tariffCode = null, $annualBeforeDiscounts = null, $periodBeforeDiscounts = null, $annualAfterDiscounts = null, $periodAfterDiscounts = null, $tariffCoefsBeforeDiscounts = null, $tariffCoefsAfterDiscounts = null, array $tariffDiscounts = array())
    {
        $this
            ->setTariffCode($tariffCode)
            ->setAnnualBeforeDiscounts($annualBeforeDiscounts)
            ->setPeriodBeforeDiscounts($periodBeforeDiscounts)
            ->setAnnualAfterDiscounts($annualAfterDiscounts)
            ->setPeriodAfterDiscounts($periodAfterDiscounts)
            ->setTariffCoefsBeforeDiscounts($tariffCoefsBeforeDiscounts)
            ->setTariffCoefsAfterDiscounts($tariffCoefsAfterDiscounts)
            ->setTariffDiscounts($tariffDiscounts);
    }
    /**
     * Get tariffCode value
     * @return string|null
     */
    public function getTariffCode()
    {
        return $this->tariffCode;
    }
    /**
     * Set tariffCode value
     * @param string $tariffCode
     * @return \StructType\TariffPrice
     */
    public function setTariffCode($tariffCode = null)
    {
        // validation for constraint: string
        if (!is_null($tariffCode) && !is_string($tariffCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffCode)), __LINE__);
        }
        $this->tariffCode = $tariffCode;
        return $this;
    }
    /**
     * Get annualBeforeDiscounts value
     * @return float|null
     */
    public function getAnnualBeforeDiscounts()
    {
        return $this->annualBeforeDiscounts;
    }
    /**
     * Set annualBeforeDiscounts value
     * @param float $annualBeforeDiscounts
     * @return \StructType\TariffPrice
     */
    public function setAnnualBeforeDiscounts($annualBeforeDiscounts = null)
    {
        $this->annualBeforeDiscounts = $annualBeforeDiscounts;
        return $this;
    }
    /**
     * Get periodBeforeDiscounts value
     * @return float|null
     */
    public function getPeriodBeforeDiscounts()
    {
        return $this->periodBeforeDiscounts;
    }
    /**
     * Set periodBeforeDiscounts value
     * @param float $periodBeforeDiscounts
     * @return \StructType\TariffPrice
     */
    public function setPeriodBeforeDiscounts($periodBeforeDiscounts = null)
    {
        $this->periodBeforeDiscounts = $periodBeforeDiscounts;
        return $this;
    }
    /**
     * Get annualAfterDiscounts value
     * @return float|null
     */
    public function getAnnualAfterDiscounts()
    {
        return $this->annualAfterDiscounts;
    }
    /**
     * Set annualAfterDiscounts value
     * @param float $annualAfterDiscounts
     * @return \StructType\TariffPrice
     */
    public function setAnnualAfterDiscounts($annualAfterDiscounts = null)
    {
        $this->annualAfterDiscounts = $annualAfterDiscounts;
        return $this;
    }
    /**
     * Get periodAfterDiscounts value
     * @return float|null
     */
    public function getPeriodAfterDiscounts()
    {
        return $this->periodAfterDiscounts;
    }
    /**
     * Set periodAfterDiscounts value
     * @param float $periodAfterDiscounts
     * @return \StructType\TariffPrice
     */
    public function setPeriodAfterDiscounts($periodAfterDiscounts = null)
    {
        $this->periodAfterDiscounts = $periodAfterDiscounts;
        return $this;
    }
    /**
     * Get tariffCoefsBeforeDiscounts value
     * @return string|null
     */
    public function getTariffCoefsBeforeDiscounts()
    {
        return $this->tariffCoefsBeforeDiscounts;
    }
    /**
     * Set tariffCoefsBeforeDiscounts value
     * @param string $tariffCoefsBeforeDiscounts
     * @return \StructType\TariffPrice
     */
    public function setTariffCoefsBeforeDiscounts($tariffCoefsBeforeDiscounts = null)
    {
        // validation for constraint: string
        if (!is_null($tariffCoefsBeforeDiscounts) && !is_string($tariffCoefsBeforeDiscounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffCoefsBeforeDiscounts)), __LINE__);
        }
        $this->tariffCoefsBeforeDiscounts = $tariffCoefsBeforeDiscounts;
        return $this;
    }
    /**
     * Get tariffCoefsAfterDiscounts value
     * @return string|null
     */
    public function getTariffCoefsAfterDiscounts()
    {
        return $this->tariffCoefsAfterDiscounts;
    }
    /**
     * Set tariffCoefsAfterDiscounts value
     * @param string $tariffCoefsAfterDiscounts
     * @return \StructType\TariffPrice
     */
    public function setTariffCoefsAfterDiscounts($tariffCoefsAfterDiscounts = null)
    {
        // validation for constraint: string
        if (!is_null($tariffCoefsAfterDiscounts) && !is_string($tariffCoefsAfterDiscounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffCoefsAfterDiscounts)), __LINE__);
        }
        $this->tariffCoefsAfterDiscounts = $tariffCoefsAfterDiscounts;
        return $this;
    }
    /**
     * Get tariffDiscounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpusDiscount[]|null
     */
    public function getTariffDiscounts()
    {
        return isset($this->tariffDiscounts) ? $this->tariffDiscounts : null;
    }
    /**
     * Set tariffDiscounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OpusDiscount[] $tariffDiscounts
     * @return \StructType\TariffPrice
     */
    public function setTariffDiscounts(array $tariffDiscounts = array())
    {
        foreach ($tariffDiscounts as $tariffPriceTariffDiscountsItem) {
            // validation for constraint: itemType
            if (!$tariffPriceTariffDiscountsItem instanceof \StructType\OpusDiscount) {
                throw new \InvalidArgumentException(sprintf('The tariffDiscounts property can only contain items of \StructType\OpusDiscount, "%s" given', is_object($tariffPriceTariffDiscountsItem) ? get_class($tariffPriceTariffDiscountsItem) : gettype($tariffPriceTariffDiscountsItem)), __LINE__);
            }
        }
        if (is_null($tariffDiscounts) || (is_array($tariffDiscounts) && empty($tariffDiscounts))) {
            unset($this->tariffDiscounts);
        } else {
            $this->tariffDiscounts = $tariffDiscounts;
        }
        return $this;
    }
    /**
     * Add item to tariffDiscounts value
     * @throws \InvalidArgumentException
     * @param \StructType\OpusDiscount $item
     * @return \StructType\TariffPrice
     */
    public function addToTariffDiscounts(\StructType\OpusDiscount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OpusDiscount) {
            throw new \InvalidArgumentException(sprintf('The tariffDiscounts property can only contain items of \StructType\OpusDiscount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tariffDiscounts[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TariffPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
