<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyHolder StructType
 * @subpackage Structs
 */
class PolicyHolder extends AbstractStructBase
{
    /**
     * The business
     * @var bool
     */
    public $business;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $birthDate;
    /**
     * The cityCode
     * @var int
     */
    public $cityCode;
    /**
     * The sameAsVehicleHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sameAsVehicleHolder;
    /**
     * Constructor method for PolicyHolder
     * @uses PolicyHolder::setBusiness()
     * @uses PolicyHolder::setBirthDate()
     * @uses PolicyHolder::setCityCode()
     * @uses PolicyHolder::setSameAsVehicleHolder()
     * @param bool $business
     * @param string $birthDate
     * @param int $cityCode
     * @param bool $sameAsVehicleHolder
     */
    public function __construct($business = null, $birthDate = null, $cityCode = null, $sameAsVehicleHolder = null)
    {
        $this
            ->setBusiness($business)
            ->setBirthDate($birthDate)
            ->setCityCode($cityCode)
            ->setSameAsVehicleHolder($sameAsVehicleHolder);
    }
    /**
     * Get business value
     * @return bool|null
     */
    public function getBusiness()
    {
        return $this->business;
    }
    /**
     * Set business value
     * @param bool $business
     * @return \StructType\PolicyHolder
     */
    public function setBusiness($business = null)
    {
        $this->business = $business;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \StructType\PolicyHolder
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get cityCode value
     * @return int|null
     */
    public function getCityCode()
    {
        return $this->cityCode;
    }
    /**
     * Set cityCode value
     * @param int $cityCode
     * @return \StructType\PolicyHolder
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: int
        if (!is_null($cityCode) && !is_numeric($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->cityCode = $cityCode;
        return $this;
    }
    /**
     * Get sameAsVehicleHolder value
     * @return bool|null
     */
    public function getSameAsVehicleHolder()
    {
        return $this->sameAsVehicleHolder;
    }
    /**
     * Set sameAsVehicleHolder value
     * @param bool $sameAsVehicleHolder
     * @return \StructType\PolicyHolder
     */
    public function setSameAsVehicleHolder($sameAsVehicleHolder = null)
    {
        $this->sameAsVehicleHolder = $sameAsVehicleHolder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyHolder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
