<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolicyData StructType
 * @subpackage Structs
 */
class PolicyData extends AbstractPolicyData
{
    /**
     * The insurancePackages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InsurancePackage[]
     */
    public $insurancePackages;
    /**
     * Constructor method for PolicyData
     * @uses PolicyData::setInsurancePackages()
     * @param \StructType\InsurancePackage[] $insurancePackages
     */
    public function __construct(array $insurancePackages = array())
    {
        $this
            ->setInsurancePackages($insurancePackages);
    }
    /**
     * Get insurancePackages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InsurancePackage[]|null
     */
    public function getInsurancePackages()
    {
        return isset($this->insurancePackages) ? $this->insurancePackages : null;
    }
    /**
     * Set insurancePackages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePackage[] $insurancePackages
     * @return \StructType\PolicyData
     */
    public function setInsurancePackages(array $insurancePackages = array())
    {
        foreach ($insurancePackages as $policyDataInsurancePackagesItem) {
            // validation for constraint: itemType
            if (!$policyDataInsurancePackagesItem instanceof \StructType\InsurancePackage) {
                throw new \InvalidArgumentException(sprintf('The insurancePackages property can only contain items of \StructType\InsurancePackage, "%s" given', is_object($policyDataInsurancePackagesItem) ? get_class($policyDataInsurancePackagesItem) : gettype($policyDataInsurancePackagesItem)), __LINE__);
            }
        }
        if (is_null($insurancePackages) || (is_array($insurancePackages) && empty($insurancePackages))) {
            unset($this->insurancePackages);
        } else {
            $this->insurancePackages = $insurancePackages;
        }
        return $this;
    }
    /**
     * Add item to insurancePackages value
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePackage $item
     * @return \StructType\PolicyData
     */
    public function addToInsurancePackages(\StructType\InsurancePackage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsurancePackage) {
            throw new \InvalidArgumentException(sprintf('The insurancePackages property can only contain items of \StructType\InsurancePackage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->insurancePackages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PolicyData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
