<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpusDiscount StructType
 * @subpackage Structs
 */
class OpusDiscount extends AbstractStructBase
{
    /**
     * The percentageDiscount
     * @var int
     */
    public $percentageDiscount;
    /**
     * The opusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $opusCode;
    /**
     * Constructor method for OpusDiscount
     * @uses OpusDiscount::setPercentageDiscount()
     * @uses OpusDiscount::setOpusCode()
     * @param int $percentageDiscount
     * @param string $opusCode
     */
    public function __construct($percentageDiscount = null, $opusCode = null)
    {
        $this
            ->setPercentageDiscount($percentageDiscount)
            ->setOpusCode($opusCode);
    }
    /**
     * Get percentageDiscount value
     * @return int|null
     */
    public function getPercentageDiscount()
    {
        return $this->percentageDiscount;
    }
    /**
     * Set percentageDiscount value
     * @param int $percentageDiscount
     * @return \StructType\OpusDiscount
     */
    public function setPercentageDiscount($percentageDiscount = null)
    {
        // validation for constraint: int
        if (!is_null($percentageDiscount) && !is_numeric($percentageDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($percentageDiscount)), __LINE__);
        }
        $this->percentageDiscount = $percentageDiscount;
        return $this;
    }
    /**
     * Get opusCode value
     * @return string|null
     */
    public function getOpusCode()
    {
        return $this->opusCode;
    }
    /**
     * Set opusCode value
     * @param string $opusCode
     * @return \StructType\OpusDiscount
     */
    public function setOpusCode($opusCode = null)
    {
        // validation for constraint: string
        if (!is_null($opusCode) && !is_string($opusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opusCode)), __LINE__);
        }
        $this->opusCode = $opusCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpusDiscount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
