<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsurancePackage StructType
 * @subpackage Structs
 */
class InsurancePackage extends AbstractInsurancePackage
{
    /**
     * The paymentFrequencies
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $paymentFrequencies;
    /**
     * Constructor method for InsurancePackage
     * @uses InsurancePackage::setPaymentFrequencies()
     * @param string[] $paymentFrequencies
     */
    public function __construct(array $paymentFrequencies = array())
    {
        $this
            ->setPaymentFrequencies($paymentFrequencies);
    }
    /**
     * Get paymentFrequencies value
     * @return string[]|null
     */
    public function getPaymentFrequencies()
    {
        return $this->paymentFrequencies;
    }
    /**
     * Set paymentFrequencies value
     * @throws \InvalidArgumentException
     * @param string[] $paymentFrequencies
     * @return \StructType\InsurancePackage
     */
    public function setPaymentFrequencies(array $paymentFrequencies = array())
    {
        foreach ($paymentFrequencies as $insurancePackagePaymentFrequenciesItem) {
            // validation for constraint: itemType
            if (!is_string($insurancePackagePaymentFrequenciesItem)) {
                throw new \InvalidArgumentException(sprintf('The paymentFrequencies property can only contain items of string, "%s" given', is_object($insurancePackagePaymentFrequenciesItem) ? get_class($insurancePackagePaymentFrequenciesItem) : gettype($insurancePackagePaymentFrequenciesItem)), __LINE__);
            }
        }
        $this->paymentFrequencies = $paymentFrequencies;
        return $this;
    }
    /**
     * Add item to paymentFrequencies value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\InsurancePackage
     */
    public function addToPaymentFrequencies($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The paymentFrequencies property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->paymentFrequencies[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsurancePackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
