<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for checkAgainstBlacklistRequest StructType
 * Meta informations extracted from the WSDL
 * - type: tns:checkAgainstBlacklistRequest
 * @subpackage Structs
 */
class CheckAgainstBlacklistRequest extends AbstractStructBase
{
    /**
     * The trackingId
     * @var string
     */
    public $trackingId;
    /**
     * The registrationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $registrationNumber;
    /**
     * The VINNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VINNumber;
    /**
     * The personalNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $personalNumber;
    /**
     * The companyNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $companyNumber;
    /**
     * Constructor method for checkAgainstBlacklistRequest
     * @uses CheckAgainstBlacklistRequest::setTrackingId()
     * @uses CheckAgainstBlacklistRequest::setRegistrationNumber()
     * @uses CheckAgainstBlacklistRequest::setVINNumber()
     * @uses CheckAgainstBlacklistRequest::setPersonalNumber()
     * @uses CheckAgainstBlacklistRequest::setCompanyNumber()
     * @param string $trackingId
     * @param string $registrationNumber
     * @param string $vINNumber
     * @param string[] $personalNumber
     * @param string[] $companyNumber
     */
    public function __construct($trackingId = null, $registrationNumber = null, $vINNumber = null, array $personalNumber = array(), array $companyNumber = array())
    {
        $this
            ->setTrackingId($trackingId)
            ->setRegistrationNumber($registrationNumber)
            ->setVINNumber($vINNumber)
            ->setPersonalNumber($personalNumber)
            ->setCompanyNumber($companyNumber);
    }
    /**
     * Get trackingId value
     * @return string|null
     */
    public function getTrackingId()
    {
        return $this->trackingId;
    }
    /**
     * Set trackingId value
     * @param string $trackingId
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingId)), __LINE__);
        }
        $this->trackingId = $trackingId;
        return $this;
    }
    /**
     * Get registrationNumber value
     * @return string|null
     */
    public function getRegistrationNumber()
    {
        return $this->registrationNumber;
    }
    /**
     * Set registrationNumber value
     * @param string $registrationNumber
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function setRegistrationNumber($registrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($registrationNumber) && !is_string($registrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationNumber)), __LINE__);
        }
        $this->registrationNumber = $registrationNumber;
        return $this;
    }
    /**
     * Get VINNumber value
     * @return string|null
     */
    public function getVINNumber()
    {
        return $this->VINNumber;
    }
    /**
     * Set VINNumber value
     * @param string $vINNumber
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function setVINNumber($vINNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vINNumber) && !is_string($vINNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vINNumber)), __LINE__);
        }
        $this->VINNumber = $vINNumber;
        return $this;
    }
    /**
     * Get personalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getPersonalNumber()
    {
        return isset($this->personalNumber) ? $this->personalNumber : null;
    }
    /**
     * Set personalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $personalNumber
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function setPersonalNumber(array $personalNumber = array())
    {
        foreach ($personalNumber as $checkAgainstBlacklistRequestPersonalNumberItem) {
            // validation for constraint: itemType
            if (!is_string($checkAgainstBlacklistRequestPersonalNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The personalNumber property can only contain items of string, "%s" given', is_object($checkAgainstBlacklistRequestPersonalNumberItem) ? get_class($checkAgainstBlacklistRequestPersonalNumberItem) : gettype($checkAgainstBlacklistRequestPersonalNumberItem)), __LINE__);
            }
        }
        if (is_null($personalNumber) || (is_array($personalNumber) && empty($personalNumber))) {
            unset($this->personalNumber);
        } else {
            $this->personalNumber = $personalNumber;
        }
        return $this;
    }
    /**
     * Add item to personalNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function addToPersonalNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The personalNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->personalNumber[] = $item;
        return $this;
    }
    /**
     * Get companyNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getCompanyNumber()
    {
        return isset($this->companyNumber) ? $this->companyNumber : null;
    }
    /**
     * Set companyNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $companyNumber
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function setCompanyNumber(array $companyNumber = array())
    {
        foreach ($companyNumber as $checkAgainstBlacklistRequestCompanyNumberItem) {
            // validation for constraint: itemType
            if (!is_string($checkAgainstBlacklistRequestCompanyNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The companyNumber property can only contain items of string, "%s" given', is_object($checkAgainstBlacklistRequestCompanyNumberItem) ? get_class($checkAgainstBlacklistRequestCompanyNumberItem) : gettype($checkAgainstBlacklistRequestCompanyNumberItem)), __LINE__);
            }
        }
        if (is_null($companyNumber) || (is_array($companyNumber) && empty($companyNumber))) {
            unset($this->companyNumber);
        } else {
            $this->companyNumber = $companyNumber;
        }
        return $this;
    }
    /**
     * Add item to companyNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public function addToCompanyNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The companyNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->companyNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckAgainstBlacklistRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
