<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculatePricesResponse StructType
 * @subpackage Structs
 */
class CalculatePricesResponse extends AbstractCalculatePricesResponse
{
    /**
     * The insurancePrices
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InsurancePackagePrices[]
     */
    public $insurancePrices;
    /**
     * Constructor method for CalculatePricesResponse
     * @uses CalculatePricesResponse::setInsurancePrices()
     * @param \StructType\InsurancePackagePrices[] $insurancePrices
     */
    public function __construct(array $insurancePrices = array())
    {
        $this
            ->setInsurancePrices($insurancePrices);
    }
    /**
     * Get insurancePrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InsurancePackagePrices[]|null
     */
    public function getInsurancePrices()
    {
        return isset($this->insurancePrices) ? $this->insurancePrices : null;
    }
    /**
     * Set insurancePrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePackagePrices[] $insurancePrices
     * @return \StructType\CalculatePricesResponse
     */
    public function setInsurancePrices(array $insurancePrices = array())
    {
        foreach ($insurancePrices as $calculatePricesResponseInsurancePricesItem) {
            // validation for constraint: itemType
            if (!$calculatePricesResponseInsurancePricesItem instanceof \StructType\InsurancePackagePrices) {
                throw new \InvalidArgumentException(sprintf('The insurancePrices property can only contain items of \StructType\InsurancePackagePrices, "%s" given', is_object($calculatePricesResponseInsurancePricesItem) ? get_class($calculatePricesResponseInsurancePricesItem) : gettype($calculatePricesResponseInsurancePricesItem)), __LINE__);
            }
        }
        if (is_null($insurancePrices) || (is_array($insurancePrices) && empty($insurancePrices))) {
            unset($this->insurancePrices);
        } else {
            $this->insurancePrices = $insurancePrices;
        }
        return $this;
    }
    /**
     * Add item to insurancePrices value
     * @throws \InvalidArgumentException
     * @param \StructType\InsurancePackagePrices $item
     * @return \StructType\CalculatePricesResponse
     */
    public function addToInsurancePrices(\StructType\InsurancePackagePrices $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InsurancePackagePrices) {
            throw new \InvalidArgumentException(sprintf('The insurancePrices property can only contain items of \StructType\InsurancePackagePrices, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->insurancePrices[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalculatePricesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
