<?php

namespace EnumType;

/**
 * This class stands for TariffCode EnumType
 * @subpackage Enumerations
 */
class TariffCode
{
    /**
     * Constant for value 'PR'
     * @return string 'PR'
     */
    const VALUE_PR = 'PR';
    /**
     * Constant for value 'HP'
     * @return string 'HP'
     */
    const VALUE_HP = 'HP';
    /**
     * Constant for value 'ZIV'
     * @return string 'ZIV'
     */
    const VALUE_ZIV = 'ZIV';
    /**
     * Constant for value 'OV'
     * @return string 'OV'
     */
    const VALUE_OV = 'OV';
    /**
     * Constant for value 'GAP'
     * @return string 'GAP'
     */
    const VALUE_GAP = 'GAP';
    /**
     * Constant for value 'SZ'
     * @return string 'SZ'
     */
    const VALUE_SZ = 'SZ';
    /**
     * Constant for value 'OD'
     * @return string 'OD'
     */
    const VALUE_OD = 'OD';
    /**
     * Constant for value 'SZPZ'
     * @return string 'SZPZ'
     */
    const VALUE_SZPZ = 'SZPZ';
    /**
     * Constant for value 'ZIVM'
     * @return string 'ZIVM'
     */
    const VALUE_ZIVM = 'ZIVM';
    /**
     * Constant for value 'PLMO'
     * @return string 'PLMO'
     */
    const VALUE_PLMO = 'PLMO';
    /**
     * Constant for value 'SKLL'
     * @return string 'SKLL'
     */
    const VALUE_SKLL = 'SKLL';
    /**
     * Constant for value 'ZAV'
     * @return string 'ZAV'
     */
    const VALUE_ZAV = 'ZAV';
    /**
     * Constant for value 'UPS'
     * @return string 'UPS'
     */
    const VALUE_UPS = 'UPS';
    /**
     * Constant for value 'UPR'
     * @return string 'UPR'
     */
    const VALUE_UPR = 'UPR';
    /**
     * Constant for value 'ASPV'
     * @return string 'ASPV'
     */
    const VALUE_ASPV = 'ASPV';
    /**
     * Constant for value 'ASPB'
     * @return string 'ASPB'
     */
    const VALUE_ASPB = 'ASPB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PR
     * @uses self::VALUE_HP
     * @uses self::VALUE_ZIV
     * @uses self::VALUE_OV
     * @uses self::VALUE_GAP
     * @uses self::VALUE_SZ
     * @uses self::VALUE_OD
     * @uses self::VALUE_SZPZ
     * @uses self::VALUE_ZIVM
     * @uses self::VALUE_PLMO
     * @uses self::VALUE_SKLL
     * @uses self::VALUE_ZAV
     * @uses self::VALUE_UPS
     * @uses self::VALUE_UPR
     * @uses self::VALUE_ASPV
     * @uses self::VALUE_ASPB
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PR,
            self::VALUE_HP,
            self::VALUE_ZIV,
            self::VALUE_OV,
            self::VALUE_GAP,
            self::VALUE_SZ,
            self::VALUE_OD,
            self::VALUE_SZPZ,
            self::VALUE_ZIVM,
            self::VALUE_PLMO,
            self::VALUE_SKLL,
            self::VALUE_ZAV,
            self::VALUE_UPS,
            self::VALUE_UPR,
            self::VALUE_ASPV,
            self::VALUE_ASPB,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
