<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.allianzdirect.etn.cz/web/services/ws_azd_iauto?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://www.allianzdirect.etn.cz/web/services/ws_azd_iauto?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Calculate ServiceType
 */
$calculate = new \ServiceType\Calculate($options);
/**
 * Sample call for calculatePrices2 operation/method
 */
if ($calculate->calculatePrices2(new \StructType\CalculatePrices2Request()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Sample call for calculatePrices operation/method
 */
if ($calculate->calculatePrices(new \StructType\CalculatePricesRequest()) !== false) {
    print_r($calculate->getResult());
} else {
    print_r($calculate->getLastError());
}
/**
 * Samples for Ping ServiceType
 */
$ping = new \ServiceType\Ping($options);
/**
 * Sample call for ping operation/method
 */
if ($ping->ping(new \StructType\PingRequest()) !== false) {
    print_r($ping->getResult());
} else {
    print_r($ping->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for checkAgainstBlacklist operation/method
 */
if ($check->checkAgainstBlacklist(new \StructType\CheckAgainstBlacklistRequest()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
