<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PingRequest StructType
 * @subpackage Structs
 */
class PingRequest extends AbstractStructBase
{
    /**
     * The trackingId
     * @var string
     */
    public $trackingId;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * Constructor method for PingRequest
     * @uses PingRequest::setTrackingId()
     * @uses PingRequest::setTimestamp()
     * @param string $trackingId
     * @param string $timestamp
     */
    public function __construct($trackingId = null, $timestamp = null)
    {
        $this
            ->setTrackingId($trackingId)
            ->setTimestamp($timestamp);
    }
    /**
     * Get trackingId value
     * @return string|null
     */
    public function getTrackingId()
    {
        return $this->trackingId;
    }
    /**
     * Set trackingId value
     * @param string $trackingId
     * @return \StructType\PingRequest
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingId)), __LINE__);
        }
        $this->trackingId = $trackingId;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\PingRequest
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
