<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractCalculatePricesRequest StructType
 * @subpackage Structs
 */
abstract class AbstractCalculatePricesRequest extends AbstractStructBase
{
    /**
     * The trackingId
     * @var string
     */
    public $trackingId;
    /**
     * The subjectName
     * @var string
     */
    public $subjectName;
    /**
     * The policyHolder
     * @var \StructType\PolicyHolder
     */
    public $policyHolder;
    /**
     * Constructor method for AbstractCalculatePricesRequest
     * @uses AbstractCalculatePricesRequest::setTrackingId()
     * @uses AbstractCalculatePricesRequest::setSubjectName()
     * @uses AbstractCalculatePricesRequest::setPolicyHolder()
     * @param string $trackingId
     * @param string $subjectName
     * @param \StructType\PolicyHolder $policyHolder
     */
    public function __construct($trackingId = null, $subjectName = null, \StructType\PolicyHolder $policyHolder = null)
    {
        $this
            ->setTrackingId($trackingId)
            ->setSubjectName($subjectName)
            ->setPolicyHolder($policyHolder);
    }
    /**
     * Get trackingId value
     * @return string|null
     */
    public function getTrackingId()
    {
        return $this->trackingId;
    }
    /**
     * Set trackingId value
     * @param string $trackingId
     * @return \StructType\AbstractCalculatePricesRequest
     */
    public function setTrackingId($trackingId = null)
    {
        // validation for constraint: string
        if (!is_null($trackingId) && !is_string($trackingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($trackingId)), __LINE__);
        }
        $this->trackingId = $trackingId;
        return $this;
    }
    /**
     * Get subjectName value
     * @return string|null
     */
    public function getSubjectName()
    {
        return $this->subjectName;
    }
    /**
     * Set subjectName value
     * @param string $subjectName
     * @return \StructType\AbstractCalculatePricesRequest
     */
    public function setSubjectName($subjectName = null)
    {
        // validation for constraint: string
        if (!is_null($subjectName) && !is_string($subjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subjectName)), __LINE__);
        }
        $this->subjectName = $subjectName;
        return $this;
    }
    /**
     * Get policyHolder value
     * @return \StructType\PolicyHolder|null
     */
    public function getPolicyHolder()
    {
        return $this->policyHolder;
    }
    /**
     * Set policyHolder value
     * @param \StructType\PolicyHolder $policyHolder
     * @return \StructType\AbstractCalculatePricesRequest
     */
    public function setPolicyHolder(\StructType\PolicyHolder $policyHolder = null)
    {
        $this->policyHolder = $policyHolder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbstractCalculatePricesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
