<?php

namespace EnumType;

/**
 * This class stands for PaymentFrequency2 EnumType
 * @subpackage Enumerations
 */
class PaymentFrequency2
{
    /**
     * Constant for value 'MONTH'
     * @return string 'MONTH'
     */
    const VALUE_MONTH = 'MONTH';
    /**
     * Constant for value 'MONTH_WITHOUT_DISCOUNT'
     * @return string 'MONTH_WITHOUT_DISCOUNT'
     */
    const VALUE_MONTH_WITHOUT_DISCOUNT = 'MONTH_WITHOUT_DISCOUNT';
    /**
     * Constant for value 'YEAR'
     * @return string 'YEAR'
     */
    const VALUE_YEAR = 'YEAR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MONTH
     * @uses self::VALUE_MONTH_WITHOUT_DISCOUNT
     * @uses self::VALUE_YEAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MONTH,
            self::VALUE_MONTH_WITHOUT_DISCOUNT,
            self::VALUE_YEAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
