<?php

namespace EnumType;

/**
 * This class stands for PaymentFrequency EnumType
 * @subpackage Enumerations
 */
class PaymentFrequency
{
    /**
     * Constant for value 'YEAR'
     * @return string 'YEAR'
     */
    const VALUE_YEAR = 'YEAR';
    /**
     * Constant for value 'HALF_YEAR'
     * @return string 'HALF_YEAR'
     */
    const VALUE_HALF_YEAR = 'HALF_YEAR';
    /**
     * Constant for value 'QUARTER'
     * @return string 'QUARTER'
     */
    const VALUE_QUARTER = 'QUARTER';
    /**
     * Constant for value 'MONTH'
     * @return string 'MONTH'
     */
    const VALUE_MONTH = 'MONTH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_YEAR
     * @uses self::VALUE_HALF_YEAR
     * @uses self::VALUE_QUARTER
     * @uses self::VALUE_MONTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_YEAR,
            self::VALUE_HALF_YEAR,
            self::VALUE_QUARTER,
            self::VALUE_MONTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
