<?php

namespace EnumType;

/**
 * This class stands for ParticipationRate EnumType
 * @subpackage Enumerations
 */
class ParticipationRate
{
    /**
     * Constant for value 'P_1'
     * @return string 'P_1'
     */
    const VALUE_P_1 = 'P_1';
    /**
     * Constant for value 'P_5'
     * @return string 'P_5'
     */
    const VALUE_P_5 = 'P_5';
    /**
     * Constant for value 'P_10'
     * @return string 'P_10'
     */
    const VALUE_P_10 = 'P_10';
    /**
     * Constant for value 'P_1000'
     * @return string 'P_1000'
     */
    const VALUE_P_1000 = 'P_1000';
    /**
     * Constant for value 'P_5000'
     * @return string 'P_5000'
     */
    const VALUE_P_5000 = 'P_5000';
    /**
     * Constant for value 'P_10000'
     * @return string 'P_10000'
     */
    const VALUE_P_10000 = 'P_10000';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_P_1
     * @uses self::VALUE_P_5
     * @uses self::VALUE_P_10
     * @uses self::VALUE_P_1000
     * @uses self::VALUE_P_5000
     * @uses self::VALUE_P_10000
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_P_1,
            self::VALUE_P_5,
            self::VALUE_P_10,
            self::VALUE_P_1000,
            self::VALUE_P_5000,
            self::VALUE_P_10000,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
