<?php

namespace EnumType;

/**
 * This class stands for KilometersPerAnnum EnumType
 * @subpackage Enumerations
 */
class KilometersPerAnnum
{
    /**
     * Constant for value 'PPU_LESS_THAN_5000'
     * @return string 'PPU_LESS_THAN_5000'
     */
    const VALUE_PPU_LESS_THAN_5000 = 'PPU_LESS_THAN_5000';
    /**
     * Constant for value 'PPU_5000_TO_7500'
     * @return string 'PPU_5000_TO_7500'
     */
    const VALUE_PPU_5000_TO_7500 = 'PPU_5000_TO_7500';
    /**
     * Constant for value 'PPU_7501_TO_10000'
     * @return string 'PPU_7501_TO_10000'
     */
    const VALUE_PPU_7501_TO_10000 = 'PPU_7501_TO_10000';
    /**
     * Constant for value 'PPU_10001_TO_12500'
     * @return string 'PPU_10001_TO_12500'
     */
    const VALUE_PPU_10001_TO_12500 = 'PPU_10001_TO_12500';
    /**
     * Constant for value 'PPU_12501_TO_15000'
     * @return string 'PPU_12501_TO_15000'
     */
    const VALUE_PPU_12501_TO_15000 = 'PPU_12501_TO_15000';
    /**
     * Constant for value 'PPU_15001_TO_20000'
     * @return string 'PPU_15001_TO_20000'
     */
    const VALUE_PPU_15001_TO_20000 = 'PPU_15001_TO_20000';
    /**
     * Constant for value 'PPU_20001_TO_25000'
     * @return string 'PPU_20001_TO_25000'
     */
    const VALUE_PPU_20001_TO_25000 = 'PPU_20001_TO_25000';
    /**
     * Constant for value 'PPU_25001_TO_30000'
     * @return string 'PPU_25001_TO_30000'
     */
    const VALUE_PPU_25001_TO_30000 = 'PPU_25001_TO_30000';
    /**
     * Constant for value 'PPU_30001_TO_35000'
     * @return string 'PPU_30001_TO_35000'
     */
    const VALUE_PPU_30001_TO_35000 = 'PPU_30001_TO_35000';
    /**
     * Constant for value 'PPU_35001_TO_40000'
     * @return string 'PPU_35001_TO_40000'
     */
    const VALUE_PPU_35001_TO_40000 = 'PPU_35001_TO_40000';
    /**
     * Constant for value 'PPU_40001_TO_50000'
     * @return string 'PPU_40001_TO_50000'
     */
    const VALUE_PPU_40001_TO_50000 = 'PPU_40001_TO_50000';
    /**
     * Constant for value 'PPU_MORE_THAN_50000'
     * @return string 'PPU_MORE_THAN_50000'
     */
    const VALUE_PPU_MORE_THAN_50000 = 'PPU_MORE_THAN_50000';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PPU_LESS_THAN_5000
     * @uses self::VALUE_PPU_5000_TO_7500
     * @uses self::VALUE_PPU_7501_TO_10000
     * @uses self::VALUE_PPU_10001_TO_12500
     * @uses self::VALUE_PPU_12501_TO_15000
     * @uses self::VALUE_PPU_15001_TO_20000
     * @uses self::VALUE_PPU_20001_TO_25000
     * @uses self::VALUE_PPU_25001_TO_30000
     * @uses self::VALUE_PPU_30001_TO_35000
     * @uses self::VALUE_PPU_35001_TO_40000
     * @uses self::VALUE_PPU_40001_TO_50000
     * @uses self::VALUE_PPU_MORE_THAN_50000
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PPU_LESS_THAN_5000,
            self::VALUE_PPU_5000_TO_7500,
            self::VALUE_PPU_7501_TO_10000,
            self::VALUE_PPU_10001_TO_12500,
            self::VALUE_PPU_12501_TO_15000,
            self::VALUE_PPU_15001_TO_20000,
            self::VALUE_PPU_20001_TO_25000,
            self::VALUE_PPU_25001_TO_30000,
            self::VALUE_PPU_30001_TO_35000,
            self::VALUE_PPU_35001_TO_40000,
            self::VALUE_PPU_40001_TO_50000,
            self::VALUE_PPU_MORE_THAN_50000,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
