<?php

namespace EnumType;

/**
 * This class stands for Fuel EnumType
 * @subpackage Enumerations
 */
class Fuel
{
    /**
     * Constant for value 'NM'
     * @return string 'NM'
     */
    const VALUE_NM = 'NM';
    /**
     * Constant for value 'BA'
     * @return string 'BA'
     */
    const VALUE_BA = 'BA';
    /**
     * Constant for value 'PB'
     * @return string 'PB'
     */
    const VALUE_PB = 'PB';
    /**
     * Constant for value 'EP'
     * @return string 'EP'
     */
    const VALUE_EP = 'EP';
    /**
     * Constant for value 'HY'
     * @return string 'HY'
     */
    const VALUE_HY = 'HY';
    /**
     * Constant for value 'JI'
     * @return string 'JI'
     */
    const VALUE_JI = 'JI';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NM
     * @uses self::VALUE_BA
     * @uses self::VALUE_PB
     * @uses self::VALUE_EP
     * @uses self::VALUE_HY
     * @uses self::VALUE_JI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NM,
            self::VALUE_BA,
            self::VALUE_PB,
            self::VALUE_EP,
            self::VALUE_HY,
            self::VALUE_JI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
