<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetPackageQuantity StructType
 * @subpackage Structs
 */
class SetPackageQuantity extends AbstractStructBase
{
    /**
     * The shipmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $shipmentNo;
    /**
     * The movementNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $movementNo;
    /**
     * The packageUnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $packageUnitOfMeasure;
    /**
     * The actualQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $actualQuantity;
    /**
     * Constructor method for SetPackageQuantity
     * @uses SetPackageQuantity::setShipmentNo()
     * @uses SetPackageQuantity::setMovementNo()
     * @uses SetPackageQuantity::setPackageUnitOfMeasure()
     * @uses SetPackageQuantity::setActualQuantity()
     * @param int $shipmentNo
     * @param int $movementNo
     * @param string $packageUnitOfMeasure
     * @param int $actualQuantity
     */
    public function __construct($shipmentNo = null, $movementNo = null, $packageUnitOfMeasure = null, $actualQuantity = null)
    {
        $this
            ->setShipmentNo($shipmentNo)
            ->setMovementNo($movementNo)
            ->setPackageUnitOfMeasure($packageUnitOfMeasure)
            ->setActualQuantity($actualQuantity);
    }
    /**
     * Get shipmentNo value
     * @return int
     */
    public function getShipmentNo()
    {
        return $this->shipmentNo;
    }
    /**
     * Set shipmentNo value
     * @param int $shipmentNo
     * @return \StructType\SetPackageQuantity
     */
    public function setShipmentNo($shipmentNo = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentNo) && !(is_int($shipmentNo) || ctype_digit($shipmentNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentNo, true), gettype($shipmentNo)), __LINE__);
        }
        $this->shipmentNo = $shipmentNo;
        return $this;
    }
    /**
     * Get movementNo value
     * @return int
     */
    public function getMovementNo()
    {
        return $this->movementNo;
    }
    /**
     * Set movementNo value
     * @param int $movementNo
     * @return \StructType\SetPackageQuantity
     */
    public function setMovementNo($movementNo = null)
    {
        // validation for constraint: int
        if (!is_null($movementNo) && !(is_int($movementNo) || ctype_digit($movementNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($movementNo, true), gettype($movementNo)), __LINE__);
        }
        $this->movementNo = $movementNo;
        return $this;
    }
    /**
     * Get packageUnitOfMeasure value
     * @return string
     */
    public function getPackageUnitOfMeasure()
    {
        return $this->packageUnitOfMeasure;
    }
    /**
     * Set packageUnitOfMeasure value
     * @param string $packageUnitOfMeasure
     * @return \StructType\SetPackageQuantity
     */
    public function setPackageUnitOfMeasure($packageUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($packageUnitOfMeasure) && !is_string($packageUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageUnitOfMeasure, true), gettype($packageUnitOfMeasure)), __LINE__);
        }
        $this->packageUnitOfMeasure = $packageUnitOfMeasure;
        return $this;
    }
    /**
     * Get actualQuantity value
     * @return int
     */
    public function getActualQuantity()
    {
        return $this->actualQuantity;
    }
    /**
     * Set actualQuantity value
     * @param int $actualQuantity
     * @return \StructType\SetPackageQuantity
     */
    public function setActualQuantity($actualQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($actualQuantity) && !(is_int($actualQuantity) || ctype_digit($actualQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actualQuantity, true), gettype($actualQuantity)), __LINE__);
        }
        $this->actualQuantity = $actualQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetPackageQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
