<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetMovementGate StructType
 * @subpackage Structs
 */
class SetMovementGate extends AbstractStructBase
{
    /**
     * The shipmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $shipmentNo;
    /**
     * The movementNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $movementNo;
    /**
     * The gate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $gate;
    /**
     * Constructor method for SetMovementGate
     * @uses SetMovementGate::setShipmentNo()
     * @uses SetMovementGate::setMovementNo()
     * @uses SetMovementGate::setGate()
     * @param int $shipmentNo
     * @param int $movementNo
     * @param string $gate
     */
    public function __construct($shipmentNo = null, $movementNo = null, $gate = null)
    {
        $this
            ->setShipmentNo($shipmentNo)
            ->setMovementNo($movementNo)
            ->setGate($gate);
    }
    /**
     * Get shipmentNo value
     * @return int
     */
    public function getShipmentNo()
    {
        return $this->shipmentNo;
    }
    /**
     * Set shipmentNo value
     * @param int $shipmentNo
     * @return \StructType\SetMovementGate
     */
    public function setShipmentNo($shipmentNo = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentNo) && !(is_int($shipmentNo) || ctype_digit($shipmentNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentNo, true), gettype($shipmentNo)), __LINE__);
        }
        $this->shipmentNo = $shipmentNo;
        return $this;
    }
    /**
     * Get movementNo value
     * @return int
     */
    public function getMovementNo()
    {
        return $this->movementNo;
    }
    /**
     * Set movementNo value
     * @param int $movementNo
     * @return \StructType\SetMovementGate
     */
    public function setMovementNo($movementNo = null)
    {
        // validation for constraint: int
        if (!is_null($movementNo) && !(is_int($movementNo) || ctype_digit($movementNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($movementNo, true), gettype($movementNo)), __LINE__);
        }
        $this->movementNo = $movementNo;
        return $this;
    }
    /**
     * Get gate value
     * @return string
     */
    public function getGate()
    {
        return $this->gate;
    }
    /**
     * Set gate value
     * @param string $gate
     * @return \StructType\SetMovementGate
     */
    public function setGate($gate = null)
    {
        // validation for constraint: string
        if (!is_null($gate) && !is_string($gate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gate, true), gettype($gate)), __LINE__);
        }
        $this->gate = $gate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetMovementGate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
