<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetShipmentMovements StructType
 * @subpackage Structs
 */
class GetShipmentMovements extends AbstractStructBase
{
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $department;
    /**
     * The planDepartment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $planDepartment;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The wSMovementlist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Movements
     */
    public $wSMovementlist;
    /**
     * Constructor method for GetShipmentMovements
     * @uses GetShipmentMovements::setDepartment()
     * @uses GetShipmentMovements::setPlanDepartment()
     * @uses GetShipmentMovements::setStartDate()
     * @uses GetShipmentMovements::setWSMovementlist()
     * @param string $department
     * @param string $planDepartment
     * @param string $startDate
     * @param \StructType\Movements $wSMovementlist
     */
    public function __construct($department = null, $planDepartment = null, $startDate = null, \StructType\Movements $wSMovementlist = null)
    {
        $this
            ->setDepartment($department)
            ->setPlanDepartment($planDepartment)
            ->setStartDate($startDate)
            ->setWSMovementlist($wSMovementlist);
    }
    /**
     * Get department value
     * @return string
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param string $department
     * @return \StructType\GetShipmentMovements
     */
    public function setDepartment($department = null)
    {
        // validation for constraint: string
        if (!is_null($department) && !is_string($department)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($department, true), gettype($department)), __LINE__);
        }
        $this->department = $department;
        return $this;
    }
    /**
     * Get planDepartment value
     * @return string
     */
    public function getPlanDepartment()
    {
        return $this->planDepartment;
    }
    /**
     * Set planDepartment value
     * @param string $planDepartment
     * @return \StructType\GetShipmentMovements
     */
    public function setPlanDepartment($planDepartment = null)
    {
        // validation for constraint: string
        if (!is_null($planDepartment) && !is_string($planDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planDepartment, true), gettype($planDepartment)), __LINE__);
        }
        $this->planDepartment = $planDepartment;
        return $this;
    }
    /**
     * Get startDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\GetShipmentMovements
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get wSMovementlist value
     * @return \StructType\Movements
     */
    public function getWSMovementlist()
    {
        return $this->wSMovementlist;
    }
    /**
     * Set wSMovementlist value
     * @param \StructType\Movements $wSMovementlist
     * @return \StructType\GetShipmentMovements
     */
    public function setWSMovementlist(\StructType\Movements $wSMovementlist = null)
    {
        $this->wSMovementlist = $wSMovementlist;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetShipmentMovements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
