<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetMovementActualQuantity StructType
 * @subpackage Structs
 */
class SetMovementActualQuantity extends AbstractStructBase
{
    /**
     * The shipmentNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $shipmentNo;
    /**
     * The movementNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $movementNo;
    /**
     * The goodsLineNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $goodsLineNo;
    /**
     * The actualUnitOfMeasure
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $actualUnitOfMeasure;
    /**
     * The actualQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $actualQuantity;
    /**
     * Constructor method for SetMovementActualQuantity
     * @uses SetMovementActualQuantity::setShipmentNo()
     * @uses SetMovementActualQuantity::setMovementNo()
     * @uses SetMovementActualQuantity::setGoodsLineNo()
     * @uses SetMovementActualQuantity::setActualUnitOfMeasure()
     * @uses SetMovementActualQuantity::setActualQuantity()
     * @param int $shipmentNo
     * @param int $movementNo
     * @param int $goodsLineNo
     * @param string $actualUnitOfMeasure
     * @param int $actualQuantity
     */
    public function __construct($shipmentNo = null, $movementNo = null, $goodsLineNo = null, $actualUnitOfMeasure = null, $actualQuantity = null)
    {
        $this
            ->setShipmentNo($shipmentNo)
            ->setMovementNo($movementNo)
            ->setGoodsLineNo($goodsLineNo)
            ->setActualUnitOfMeasure($actualUnitOfMeasure)
            ->setActualQuantity($actualQuantity);
    }
    /**
     * Get shipmentNo value
     * @return int
     */
    public function getShipmentNo()
    {
        return $this->shipmentNo;
    }
    /**
     * Set shipmentNo value
     * @param int $shipmentNo
     * @return \StructType\SetMovementActualQuantity
     */
    public function setShipmentNo($shipmentNo = null)
    {
        // validation for constraint: int
        if (!is_null($shipmentNo) && !(is_int($shipmentNo) || ctype_digit($shipmentNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentNo, true), gettype($shipmentNo)), __LINE__);
        }
        $this->shipmentNo = $shipmentNo;
        return $this;
    }
    /**
     * Get movementNo value
     * @return int
     */
    public function getMovementNo()
    {
        return $this->movementNo;
    }
    /**
     * Set movementNo value
     * @param int $movementNo
     * @return \StructType\SetMovementActualQuantity
     */
    public function setMovementNo($movementNo = null)
    {
        // validation for constraint: int
        if (!is_null($movementNo) && !(is_int($movementNo) || ctype_digit($movementNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($movementNo, true), gettype($movementNo)), __LINE__);
        }
        $this->movementNo = $movementNo;
        return $this;
    }
    /**
     * Get goodsLineNo value
     * @return int
     */
    public function getGoodsLineNo()
    {
        return $this->goodsLineNo;
    }
    /**
     * Set goodsLineNo value
     * @param int $goodsLineNo
     * @return \StructType\SetMovementActualQuantity
     */
    public function setGoodsLineNo($goodsLineNo = null)
    {
        // validation for constraint: int
        if (!is_null($goodsLineNo) && !(is_int($goodsLineNo) || ctype_digit($goodsLineNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($goodsLineNo, true), gettype($goodsLineNo)), __LINE__);
        }
        $this->goodsLineNo = $goodsLineNo;
        return $this;
    }
    /**
     * Get actualUnitOfMeasure value
     * @return string
     */
    public function getActualUnitOfMeasure()
    {
        return $this->actualUnitOfMeasure;
    }
    /**
     * Set actualUnitOfMeasure value
     * @param string $actualUnitOfMeasure
     * @return \StructType\SetMovementActualQuantity
     */
    public function setActualUnitOfMeasure($actualUnitOfMeasure = null)
    {
        // validation for constraint: string
        if (!is_null($actualUnitOfMeasure) && !is_string($actualUnitOfMeasure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualUnitOfMeasure, true), gettype($actualUnitOfMeasure)), __LINE__);
        }
        $this->actualUnitOfMeasure = $actualUnitOfMeasure;
        return $this;
    }
    /**
     * Get actualQuantity value
     * @return int
     */
    public function getActualQuantity()
    {
        return $this->actualQuantity;
    }
    /**
     * Set actualQuantity value
     * @param int $actualQuantity
     * @return \StructType\SetMovementActualQuantity
     */
    public function setActualQuantity($actualQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($actualQuantity) && !(is_int($actualQuantity) || ctype_digit($actualQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actualQuantity, true), gettype($actualQuantity)), __LINE__);
        }
        $this->actualQuantity = $actualQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetMovementActualQuantity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
