<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Movements StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * - type: tns:Movements
 * @subpackage Structs
 */
class Movements extends AbstractStructBase
{
    /**
     * The Movement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Movement[]
     */
    public $Movement;
    /**
     * Constructor method for Movements
     * @uses Movements::setMovement()
     * @param \StructType\Movement[] $movement
     */
    public function __construct(array $movement = array())
    {
        $this
            ->setMovement($movement);
    }
    /**
     * Get Movement value
     * @return \StructType\Movement[]
     */
    public function getMovement()
    {
        return $this->Movement;
    }
    /**
     * This method is responsible for validating the values passed to the setMovement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMovement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMovementForArrayConstraintsFromSetMovement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementsMovementItem) {
            // validation for constraint: itemType
            if (!$movementsMovementItem instanceof \StructType\Movement) {
                $invalidValues[] = is_object($movementsMovementItem) ? get_class($movementsMovementItem) : sprintf('%s(%s)', gettype($movementsMovementItem), var_export($movementsMovementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Movement property can only contain items of type \StructType\Movement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Movement value
     * @throws \InvalidArgumentException
     * @param \StructType\Movement[] $movement
     * @return \StructType\Movements
     */
    public function setMovement(array $movement = array())
    {
        // validation for constraint: array
        if ('' !== ($movementArrayErrorMessage = self::validateMovementForArrayConstraintsFromSetMovement($movement))) {
            throw new \InvalidArgumentException($movementArrayErrorMessage, __LINE__);
        }
        $this->Movement = $movement;
        return $this;
    }
    /**
     * Add item to Movement value
     * @throws \InvalidArgumentException
     * @param \StructType\Movement $item
     * @return \StructType\Movements
     */
    public function addToMovement(\StructType\Movement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Movement) {
            throw new \InvalidArgumentException(sprintf('The Movement property can only contain items of type \StructType\Movement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Movement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Movements
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
