<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Movement StructType
 * @subpackage Structs
 */
class Movement extends AbstractStructBase
{
    /**
     * The ShipmentNo
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ShipmentNo;
    /**
     * The MovementNo
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MovementNo;
    /**
     * The PlanDepartment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PlanDepartment;
    /**
     * The Subdepartment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Subdepartment;
    /**
     * The StartAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartAddress;
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - default: 00:00:00
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $StartTime;
    /**
     * The TripNo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $TripNo;
    /**
     * The Vehicle
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $Vehicle;
    /**
     * The RouteSequenceNo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $RouteSequenceNo;
    /**
     * The SenderCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $SenderCode;
    /**
     * The SenderName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $SenderName;
    /**
     * The CustomersCustomer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $CustomersCustomer;
    /**
     * The ReceiverCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ReceiverCode;
    /**
     * The ReceiverName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ReceiverName;
    /**
     * The PortNr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PortNr;
    /**
     * The Goods
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Goods[]
     */
    public $Goods;
    /**
     * The Package
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Package[]
     */
    public $Package;
    /**
     * Constructor method for Movement
     * @uses Movement::setShipmentNo()
     * @uses Movement::setMovementNo()
     * @uses Movement::setPlanDepartment()
     * @uses Movement::setSubdepartment()
     * @uses Movement::setStartAddress()
     * @uses Movement::setStartTime()
     * @uses Movement::setTripNo()
     * @uses Movement::setVehicle()
     * @uses Movement::setRouteSequenceNo()
     * @uses Movement::setSenderCode()
     * @uses Movement::setSenderName()
     * @uses Movement::setCustomersCustomer()
     * @uses Movement::setReceiverCode()
     * @uses Movement::setReceiverName()
     * @uses Movement::setPortNr()
     * @uses Movement::setGoods()
     * @uses Movement::setPackage()
     * @param int $shipmentNo
     * @param int $movementNo
     * @param string $planDepartment
     * @param string $subdepartment
     * @param string $startAddress
     * @param string $startTime
     * @param string[] $tripNo
     * @param string[] $vehicle
     * @param string[] $routeSequenceNo
     * @param string[] $senderCode
     * @param string[] $senderName
     * @param string[] $customersCustomer
     * @param string[] $receiverCode
     * @param string[] $receiverName
     * @param string $portNr
     * @param \StructType\Goods[] $goods
     * @param \StructType\Package[] $package
     */
    public function __construct($shipmentNo = 0, $movementNo = 0, $planDepartment = null, $subdepartment = null, $startAddress = null, $startTime = 0, array $tripNo = array(), array $vehicle = array(), array $routeSequenceNo = array(), array $senderCode = array(), array $senderName = array(), array $customersCustomer = array(), array $receiverCode = array(), array $receiverName = array(), $portNr = null, array $goods = array(), array $package = array())
    {
        $this
            ->setShipmentNo($shipmentNo)
            ->setMovementNo($movementNo)
            ->setPlanDepartment($planDepartment)
            ->setSubdepartment($subdepartment)
            ->setStartAddress($startAddress)
            ->setStartTime($startTime)
            ->setTripNo($tripNo)
            ->setVehicle($vehicle)
            ->setRouteSequenceNo($routeSequenceNo)
            ->setSenderCode($senderCode)
            ->setSenderName($senderName)
            ->setCustomersCustomer($customersCustomer)
            ->setReceiverCode($receiverCode)
            ->setReceiverName($receiverName)
            ->setPortNr($portNr)
            ->setGoods($goods)
            ->setPackage($package);
    }
    /**
     * Get ShipmentNo value
     * @return int
     */
    public function getShipmentNo()
    {
        return $this->ShipmentNo;
    }
    /**
     * Set ShipmentNo value
     * @param int $shipmentNo
     * @return \StructType\Movement
     */
    public function setShipmentNo($shipmentNo = 0)
    {
        // validation for constraint: int
        if (!is_null($shipmentNo) && !(is_int($shipmentNo) || ctype_digit($shipmentNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipmentNo, true), gettype($shipmentNo)), __LINE__);
        }
        $this->ShipmentNo = $shipmentNo;
        return $this;
    }
    /**
     * Get MovementNo value
     * @return int
     */
    public function getMovementNo()
    {
        return $this->MovementNo;
    }
    /**
     * Set MovementNo value
     * @param int $movementNo
     * @return \StructType\Movement
     */
    public function setMovementNo($movementNo = 0)
    {
        // validation for constraint: int
        if (!is_null($movementNo) && !(is_int($movementNo) || ctype_digit($movementNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($movementNo, true), gettype($movementNo)), __LINE__);
        }
        $this->MovementNo = $movementNo;
        return $this;
    }
    /**
     * Get PlanDepartment value
     * @return string
     */
    public function getPlanDepartment()
    {
        return $this->PlanDepartment;
    }
    /**
     * Set PlanDepartment value
     * @param string $planDepartment
     * @return \StructType\Movement
     */
    public function setPlanDepartment($planDepartment = null)
    {
        // validation for constraint: string
        if (!is_null($planDepartment) && !is_string($planDepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($planDepartment, true), gettype($planDepartment)), __LINE__);
        }
        $this->PlanDepartment = $planDepartment;
        return $this;
    }
    /**
     * Get Subdepartment value
     * @return string
     */
    public function getSubdepartment()
    {
        return $this->Subdepartment;
    }
    /**
     * Set Subdepartment value
     * @param string $subdepartment
     * @return \StructType\Movement
     */
    public function setSubdepartment($subdepartment = null)
    {
        // validation for constraint: string
        if (!is_null($subdepartment) && !is_string($subdepartment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subdepartment, true), gettype($subdepartment)), __LINE__);
        }
        $this->Subdepartment = $subdepartment;
        return $this;
    }
    /**
     * Get StartAddress value
     * @return string
     */
    public function getStartAddress()
    {
        return $this->StartAddress;
    }
    /**
     * Set StartAddress value
     * @param string $startAddress
     * @return \StructType\Movement
     */
    public function setStartAddress($startAddress = null)
    {
        // validation for constraint: string
        if (!is_null($startAddress) && !is_string($startAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startAddress, true), gettype($startAddress)), __LINE__);
        }
        $this->StartAddress = $startAddress;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\Movement
     */
    public function setStartTime($startTime = 0)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get TripNo value
     * @return string[]
     */
    public function getTripNo()
    {
        return $this->TripNo;
    }
    /**
     * This method is responsible for validating the values passed to the setTripNo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTripNo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTripNoForArrayConstraintsFromSetTripNo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementTripNoItem) {
            // validation for constraint: itemType
            if (!is_string($movementTripNoItem)) {
                $invalidValues[] = is_object($movementTripNoItem) ? get_class($movementTripNoItem) : sprintf('%s(%s)', gettype($movementTripNoItem), var_export($movementTripNoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TripNo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TripNo value
     * @throws \InvalidArgumentException
     * @param string[] $tripNo
     * @return \StructType\Movement
     */
    public function setTripNo(array $tripNo = array())
    {
        // validation for constraint: array
        if ('' !== ($tripNoArrayErrorMessage = self::validateTripNoForArrayConstraintsFromSetTripNo($tripNo))) {
            throw new \InvalidArgumentException($tripNoArrayErrorMessage, __LINE__);
        }
        $this->TripNo = $tripNo;
        return $this;
    }
    /**
     * Add item to TripNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToTripNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The TripNo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TripNo[] = $item;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return string[]
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * This method is responsible for validating the values passed to the setVehicle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVehicle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVehicleForArrayConstraintsFromSetVehicle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementVehicleItem) {
            // validation for constraint: itemType
            if (!is_string($movementVehicleItem)) {
                $invalidValues[] = is_object($movementVehicleItem) ? get_class($movementVehicleItem) : sprintf('%s(%s)', gettype($movementVehicleItem), var_export($movementVehicleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Vehicle property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Vehicle value
     * @throws \InvalidArgumentException
     * @param string[] $vehicle
     * @return \StructType\Movement
     */
    public function setVehicle(array $vehicle = array())
    {
        // validation for constraint: array
        if ('' !== ($vehicleArrayErrorMessage = self::validateVehicleForArrayConstraintsFromSetVehicle($vehicle))) {
            throw new \InvalidArgumentException($vehicleArrayErrorMessage, __LINE__);
        }
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Add item to Vehicle value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToVehicle($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Vehicle property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Vehicle[] = $item;
        return $this;
    }
    /**
     * Get RouteSequenceNo value
     * @return string[]
     */
    public function getRouteSequenceNo()
    {
        return $this->RouteSequenceNo;
    }
    /**
     * This method is responsible for validating the values passed to the setRouteSequenceNo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRouteSequenceNo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRouteSequenceNoForArrayConstraintsFromSetRouteSequenceNo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementRouteSequenceNoItem) {
            // validation for constraint: itemType
            if (!is_string($movementRouteSequenceNoItem)) {
                $invalidValues[] = is_object($movementRouteSequenceNoItem) ? get_class($movementRouteSequenceNoItem) : sprintf('%s(%s)', gettype($movementRouteSequenceNoItem), var_export($movementRouteSequenceNoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RouteSequenceNo property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RouteSequenceNo value
     * @throws \InvalidArgumentException
     * @param string[] $routeSequenceNo
     * @return \StructType\Movement
     */
    public function setRouteSequenceNo(array $routeSequenceNo = array())
    {
        // validation for constraint: array
        if ('' !== ($routeSequenceNoArrayErrorMessage = self::validateRouteSequenceNoForArrayConstraintsFromSetRouteSequenceNo($routeSequenceNo))) {
            throw new \InvalidArgumentException($routeSequenceNoArrayErrorMessage, __LINE__);
        }
        $this->RouteSequenceNo = $routeSequenceNo;
        return $this;
    }
    /**
     * Add item to RouteSequenceNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToRouteSequenceNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The RouteSequenceNo property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RouteSequenceNo[] = $item;
        return $this;
    }
    /**
     * Get SenderCode value
     * @return string[]
     */
    public function getSenderCode()
    {
        return $this->SenderCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSenderCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSenderCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSenderCodeForArrayConstraintsFromSetSenderCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementSenderCodeItem) {
            // validation for constraint: itemType
            if (!is_string($movementSenderCodeItem)) {
                $invalidValues[] = is_object($movementSenderCodeItem) ? get_class($movementSenderCodeItem) : sprintf('%s(%s)', gettype($movementSenderCodeItem), var_export($movementSenderCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SenderCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SenderCode value
     * @throws \InvalidArgumentException
     * @param string[] $senderCode
     * @return \StructType\Movement
     */
    public function setSenderCode(array $senderCode = array())
    {
        // validation for constraint: array
        if ('' !== ($senderCodeArrayErrorMessage = self::validateSenderCodeForArrayConstraintsFromSetSenderCode($senderCode))) {
            throw new \InvalidArgumentException($senderCodeArrayErrorMessage, __LINE__);
        }
        $this->SenderCode = $senderCode;
        return $this;
    }
    /**
     * Add item to SenderCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToSenderCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SenderCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SenderCode[] = $item;
        return $this;
    }
    /**
     * Get SenderName value
     * @return string[]
     */
    public function getSenderName()
    {
        return $this->SenderName;
    }
    /**
     * This method is responsible for validating the values passed to the setSenderName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSenderName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSenderNameForArrayConstraintsFromSetSenderName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementSenderNameItem) {
            // validation for constraint: itemType
            if (!is_string($movementSenderNameItem)) {
                $invalidValues[] = is_object($movementSenderNameItem) ? get_class($movementSenderNameItem) : sprintf('%s(%s)', gettype($movementSenderNameItem), var_export($movementSenderNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SenderName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SenderName value
     * @throws \InvalidArgumentException
     * @param string[] $senderName
     * @return \StructType\Movement
     */
    public function setSenderName(array $senderName = array())
    {
        // validation for constraint: array
        if ('' !== ($senderNameArrayErrorMessage = self::validateSenderNameForArrayConstraintsFromSetSenderName($senderName))) {
            throw new \InvalidArgumentException($senderNameArrayErrorMessage, __LINE__);
        }
        $this->SenderName = $senderName;
        return $this;
    }
    /**
     * Add item to SenderName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToSenderName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The SenderName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SenderName[] = $item;
        return $this;
    }
    /**
     * Get CustomersCustomer value
     * @return string[]
     */
    public function getCustomersCustomer()
    {
        return $this->CustomersCustomer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomersCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomersCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomersCustomerForArrayConstraintsFromSetCustomersCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementCustomersCustomerItem) {
            // validation for constraint: itemType
            if (!is_string($movementCustomersCustomerItem)) {
                $invalidValues[] = is_object($movementCustomersCustomerItem) ? get_class($movementCustomersCustomerItem) : sprintf('%s(%s)', gettype($movementCustomersCustomerItem), var_export($movementCustomersCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomersCustomer property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomersCustomer value
     * @throws \InvalidArgumentException
     * @param string[] $customersCustomer
     * @return \StructType\Movement
     */
    public function setCustomersCustomer(array $customersCustomer = array())
    {
        // validation for constraint: array
        if ('' !== ($customersCustomerArrayErrorMessage = self::validateCustomersCustomerForArrayConstraintsFromSetCustomersCustomer($customersCustomer))) {
            throw new \InvalidArgumentException($customersCustomerArrayErrorMessage, __LINE__);
        }
        $this->CustomersCustomer = $customersCustomer;
        return $this;
    }
    /**
     * Add item to CustomersCustomer value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToCustomersCustomer($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CustomersCustomer property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomersCustomer[] = $item;
        return $this;
    }
    /**
     * Get ReceiverCode value
     * @return string[]
     */
    public function getReceiverCode()
    {
        return $this->ReceiverCode;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiverCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiverCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiverCodeForArrayConstraintsFromSetReceiverCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementReceiverCodeItem) {
            // validation for constraint: itemType
            if (!is_string($movementReceiverCodeItem)) {
                $invalidValues[] = is_object($movementReceiverCodeItem) ? get_class($movementReceiverCodeItem) : sprintf('%s(%s)', gettype($movementReceiverCodeItem), var_export($movementReceiverCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiverCode property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiverCode value
     * @throws \InvalidArgumentException
     * @param string[] $receiverCode
     * @return \StructType\Movement
     */
    public function setReceiverCode(array $receiverCode = array())
    {
        // validation for constraint: array
        if ('' !== ($receiverCodeArrayErrorMessage = self::validateReceiverCodeForArrayConstraintsFromSetReceiverCode($receiverCode))) {
            throw new \InvalidArgumentException($receiverCodeArrayErrorMessage, __LINE__);
        }
        $this->ReceiverCode = $receiverCode;
        return $this;
    }
    /**
     * Add item to ReceiverCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToReceiverCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReceiverCode property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiverCode[] = $item;
        return $this;
    }
    /**
     * Get ReceiverName value
     * @return string[]
     */
    public function getReceiverName()
    {
        return $this->ReceiverName;
    }
    /**
     * This method is responsible for validating the values passed to the setReceiverName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceiverName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceiverNameForArrayConstraintsFromSetReceiverName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementReceiverNameItem) {
            // validation for constraint: itemType
            if (!is_string($movementReceiverNameItem)) {
                $invalidValues[] = is_object($movementReceiverNameItem) ? get_class($movementReceiverNameItem) : sprintf('%s(%s)', gettype($movementReceiverNameItem), var_export($movementReceiverNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ReceiverName property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ReceiverName value
     * @throws \InvalidArgumentException
     * @param string[] $receiverName
     * @return \StructType\Movement
     */
    public function setReceiverName(array $receiverName = array())
    {
        // validation for constraint: array
        if ('' !== ($receiverNameArrayErrorMessage = self::validateReceiverNameForArrayConstraintsFromSetReceiverName($receiverName))) {
            throw new \InvalidArgumentException($receiverNameArrayErrorMessage, __LINE__);
        }
        $this->ReceiverName = $receiverName;
        return $this;
    }
    /**
     * Add item to ReceiverName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Movement
     */
    public function addToReceiverName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ReceiverName property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ReceiverName[] = $item;
        return $this;
    }
    /**
     * Get PortNr value
     * @return string
     */
    public function getPortNr()
    {
        return $this->PortNr;
    }
    /**
     * Set PortNr value
     * @param string $portNr
     * @return \StructType\Movement
     */
    public function setPortNr($portNr = null)
    {
        // validation for constraint: string
        if (!is_null($portNr) && !is_string($portNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($portNr, true), gettype($portNr)), __LINE__);
        }
        $this->PortNr = $portNr;
        return $this;
    }
    /**
     * Get Goods value
     * @return \StructType\Goods[]|null
     */
    public function getGoods()
    {
        return $this->Goods;
    }
    /**
     * This method is responsible for validating the values passed to the setGoods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoods method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoodsForArrayConstraintsFromSetGoods(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementGoodsItem) {
            // validation for constraint: itemType
            if (!$movementGoodsItem instanceof \StructType\Goods) {
                $invalidValues[] = is_object($movementGoodsItem) ? get_class($movementGoodsItem) : sprintf('%s(%s)', gettype($movementGoodsItem), var_export($movementGoodsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Goods property can only contain items of type \StructType\Goods, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Goods value
     * @throws \InvalidArgumentException
     * @param \StructType\Goods[] $goods
     * @return \StructType\Movement
     */
    public function setGoods(array $goods = array())
    {
        // validation for constraint: array
        if ('' !== ($goodsArrayErrorMessage = self::validateGoodsForArrayConstraintsFromSetGoods($goods))) {
            throw new \InvalidArgumentException($goodsArrayErrorMessage, __LINE__);
        }
        $this->Goods = $goods;
        return $this;
    }
    /**
     * Add item to Goods value
     * @throws \InvalidArgumentException
     * @param \StructType\Goods $item
     * @return \StructType\Movement
     */
    public function addToGoods(\StructType\Goods $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Goods) {
            throw new \InvalidArgumentException(sprintf('The Goods property can only contain items of type \StructType\Goods, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Goods[] = $item;
        return $this;
    }
    /**
     * Get Package value
     * @return \StructType\Package[]|null
     */
    public function getPackage()
    {
        return $this->Package;
    }
    /**
     * This method is responsible for validating the values passed to the setPackage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageForArrayConstraintsFromSetPackage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $movementPackageItem) {
            // validation for constraint: itemType
            if (!$movementPackageItem instanceof \StructType\Package) {
                $invalidValues[] = is_object($movementPackageItem) ? get_class($movementPackageItem) : sprintf('%s(%s)', gettype($movementPackageItem), var_export($movementPackageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Package property can only contain items of type \StructType\Package, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package[] $package
     * @return \StructType\Movement
     */
    public function setPackage(array $package = array())
    {
        // validation for constraint: array
        if ('' !== ($packageArrayErrorMessage = self::validatePackageForArrayConstraintsFromSetPackage($package))) {
            throw new \InvalidArgumentException($packageArrayErrorMessage, __LINE__);
        }
        $this->Package = $package;
        return $this;
    }
    /**
     * Add item to Package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package $item
     * @return \StructType\Movement
     */
    public function addToPackage(\StructType\Package $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Package) {
            throw new \InvalidArgumentException(sprintf('The Package property can only contain items of type \StructType\Package, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Package[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Movement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
