<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Goods StructType
 * @subpackage Structs
 */
class Goods extends AbstractStructBase
{
    /**
     * The LineNo
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNo;
    /**
     * The Unit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Unit;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The ActualQuantity
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ActualQuantity;
    /**
     * Constructor method for Goods
     * @uses Goods::setLineNo()
     * @uses Goods::setUnit()
     * @uses Goods::setQuantity()
     * @uses Goods::setActualQuantity()
     * @param int $lineNo
     * @param string $unit
     * @param float $quantity
     * @param float $actualQuantity
     */
    public function __construct($lineNo = 0, $unit = null, $quantity = 0, $actualQuantity = 0)
    {
        $this
            ->setLineNo($lineNo)
            ->setUnit($unit)
            ->setQuantity($quantity)
            ->setActualQuantity($actualQuantity);
    }
    /**
     * Get LineNo value
     * @return int
     */
    public function getLineNo()
    {
        return $this->LineNo;
    }
    /**
     * Set LineNo value
     * @param int $lineNo
     * @return \StructType\Goods
     */
    public function setLineNo($lineNo = 0)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !(is_int($lineNo) || ctype_digit($lineNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNo, true), gettype($lineNo)), __LINE__);
        }
        $this->LineNo = $lineNo;
        return $this;
    }
    /**
     * Get Unit value
     * @return string
     */
    public function getUnit()
    {
        return $this->Unit;
    }
    /**
     * Set Unit value
     * @param string $unit
     * @return \StructType\Goods
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unit, true), gettype($unit)), __LINE__);
        }
        $this->Unit = $unit;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Goods
     */
    public function setQuantity($quantity = 0)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ActualQuantity value
     * @return float
     */
    public function getActualQuantity()
    {
        return $this->ActualQuantity;
    }
    /**
     * Set ActualQuantity value
     * @param float $actualQuantity
     * @return \StructType\Goods
     */
    public function setActualQuantity($actualQuantity = 0)
    {
        // validation for constraint: float
        if (!is_null($actualQuantity) && !(is_float($actualQuantity) || is_numeric($actualQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actualQuantity, true), gettype($actualQuantity)), __LINE__);
        }
        $this->ActualQuantity = $actualQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Goods
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
