<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetMovementActualQuantity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMovementActualQuantity $parameters
     * @return \StructType\SetMovementActualQuantity_Result|bool
     */
    public function SetMovementActualQuantity(\StructType\SetMovementActualQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetMovementActualQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetMovementGate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetMovementGate $parameters
     * @return \StructType\SetMovementGate_Result|bool
     */
    public function SetMovementGate(\StructType\SetMovementGate $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetMovementGate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetPackageQuantity
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetPackageQuantity $parameters
     * @return \StructType\SetPackageQuantity_Result|bool
     */
    public function SetPackageQuantity(\StructType\SetPackageQuantity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetPackageQuantity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetMovementActualQuantity_Result|\StructType\SetMovementGate_Result|\StructType\SetPackageQuantity_Result
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
