<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relayType StructType
 * @subpackage Structs
 */
class RelayType extends AbstractStructBase
{
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $carrier;
    /**
     * The relay_id
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $relay_id;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The address1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $address1;
    /**
     * The postcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $postcode;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: 2-letter country ISO code
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $longitude;
    /**
     * The openingHours
     * Meta information extracted from the WSDL
     * - arrayType: tns:openingHoursType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\OpeningHoursType[]
     */
    public $openingHours;
    /**
     * The address2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address2;
    /**
     * The address3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address3;
    /**
     * The address4
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $address4;
    /**
     * The picture
     * Meta information extracted from the WSDL
     * - documentation: Url of the relay picture
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $picture;
    /**
     * Constructor method for relayType
     * @uses RelayType::setCarrier()
     * @uses RelayType::setRelay_id()
     * @uses RelayType::setName()
     * @uses RelayType::setAddress1()
     * @uses RelayType::setPostcode()
     * @uses RelayType::setCity()
     * @uses RelayType::setCountry()
     * @uses RelayType::setLatitude()
     * @uses RelayType::setLongitude()
     * @uses RelayType::setOpeningHours()
     * @uses RelayType::setAddress2()
     * @uses RelayType::setAddress3()
     * @uses RelayType::setAddress4()
     * @uses RelayType::setPicture()
     * @param string $carrier
     * @param string $relay_id
     * @param string $name
     * @param string $address1
     * @param string $postcode
     * @param string $city
     * @param string $country
     * @param float $latitude
     * @param float $longitude
     * @param \Cocorico\EdnBundle\Wsdl\OpeningHoursType[] $openingHours
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $picture
     */
    public function __construct($carrier = null, $relay_id = null, $name = null, $address1 = null, $postcode = null, $city = null, $country = null, $latitude = null, $longitude = null, array $openingHours = array(), $address2 = null, $address3 = null, $address4 = null, $picture = null)
    {
        $this
            ->setCarrier($carrier)
            ->setRelay_id($relay_id)
            ->setName($name)
            ->setAddress1($address1)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setCountry($country)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setOpeningHours($openingHours)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setPicture($picture);
    }
    /**
     * Get carrier value
     * @return string
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get relay_id value
     * @return string
     */
    public function getRelay_id()
    {
        return $this->relay_id;
    }
    /**
     * Set relay_id value
     * @param string $relay_id
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setRelay_id($relay_id = null)
    {
        // validation for constraint: string
        if (!is_null($relay_id) && !is_string($relay_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relay_id, true), gettype($relay_id)), __LINE__);
        }
        $this->relay_id = $relay_id;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get address1 value
     * @return string
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1, true), gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get city value
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get latitude value
     * @return float
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get openingHours value
     * @return \Cocorico\EdnBundle\Wsdl\OpeningHoursType[]
     */
    public function getOpeningHours()
    {
        return $this->openingHours;
    }
    /**
     * This method is responsible for validating the values passed to the setOpeningHours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOpeningHours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOpeningHoursForArrayConstraintsFromSetOpeningHours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relayTypeOpeningHoursItem) {
            // validation for constraint: itemType
            if (!$relayTypeOpeningHoursItem instanceof \Cocorico\EdnBundle\Wsdl\OpeningHoursType) {
                $invalidValues[] = is_object($relayTypeOpeningHoursItem) ? get_class($relayTypeOpeningHoursItem) : sprintf('%s(%s)', gettype($relayTypeOpeningHoursItem), var_export($relayTypeOpeningHoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The openingHours property can only contain items of type \Cocorico\EdnBundle\Wsdl\OpeningHoursType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set openingHours value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\OpeningHoursType[] $openingHours
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setOpeningHours(array $openingHours = array())
    {
        // validation for constraint: array
        if ('' !== ($openingHoursArrayErrorMessage = self::validateOpeningHoursForArrayConstraintsFromSetOpeningHours($openingHours))) {
            throw new \InvalidArgumentException($openingHoursArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($openingHours) && count($openingHours) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($openingHours)), __LINE__);
        }
        $this->openingHours = $openingHours;
        return $this;
    }
    /**
     * Add item to openingHours value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\OpeningHoursType $item
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function addToOpeningHours(\Cocorico\EdnBundle\Wsdl\OpeningHoursType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\OpeningHoursType) {
            throw new \InvalidArgumentException(sprintf('The openingHours property can only contain items of type \Cocorico\EdnBundle\Wsdl\OpeningHoursType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->openingHours) && count($this->openingHours) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->openingHours)), __LINE__);
        }
        $this->openingHours[] = $item;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2, true), gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address3, true), gettype($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->address4;
    }
    /**
     * Set address4 value
     * @param string $address4
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address4, true), gettype($address4)), __LINE__);
        }
        $this->address4 = $address4;
        return $this;
    }
    /**
     * Get picture value
     * @return string|null
     */
    public function getPicture()
    {
        return $this->picture;
    }
    /**
     * Set picture value
     * @param string $picture
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public function setPicture($picture = null)
    {
        // validation for constraint: string
        if (!is_null($picture) && !is_string($picture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($picture, true), gettype($picture)), __LINE__);
        }
        $this->picture = $picture;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\RelayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
