<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productType StructType
 * @subpackage Structs
 */
class ProductType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name of the product
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - documentation: Unit price in €
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * The qty
     * Meta information extracted from the WSDL
     * - documentation: Quantity
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $qty;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Weight of the package in kilograms
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight;
    /**
     * The manufacturer
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manufacturer;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The composition
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $composition;
    /**
     * The ref
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ref;
    /**
     * The ean
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ean;
    /**
     * The hscode
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hscode;
    /**
     * The country_orig
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $country_orig;
    /**
     * The price_incl_tax
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $price_incl_tax;
    /**
     * The vat
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $vat;
    /**
     * The row_total
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $row_total;
    /**
     * The row_total_incl_tax
     * Meta information extracted from the WSDL
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $row_total_incl_tax;
    /**
     * Constructor method for productType
     * @uses ProductType::setName()
     * @uses ProductType::setPrice()
     * @uses ProductType::setQty()
     * @uses ProductType::setWeight()
     * @uses ProductType::setManufacturer()
     * @uses ProductType::setDescription()
     * @uses ProductType::setComposition()
     * @uses ProductType::setRef()
     * @uses ProductType::setEan()
     * @uses ProductType::setHscode()
     * @uses ProductType::setCountry_orig()
     * @uses ProductType::setPrice_incl_tax()
     * @uses ProductType::setVat()
     * @uses ProductType::setRow_total()
     * @uses ProductType::setRow_total_incl_tax()
     * @param string $name
     * @param float $price
     * @param float $qty
     * @param float $weight
     * @param string $manufacturer
     * @param string $description
     * @param string $composition
     * @param string $ref
     * @param string $ean
     * @param string $hscode
     * @param string $country_orig
     * @param float $price_incl_tax
     * @param float $vat
     * @param float $row_total
     * @param float $row_total_incl_tax
     */
    public function __construct($name = null, $price = null, $qty = null, $weight = null, $manufacturer = null, $description = null, $composition = null, $ref = null, $ean = null, $hscode = null, $country_orig = null, $price_incl_tax = null, $vat = null, $row_total = null, $row_total_incl_tax = null)
    {
        $this
            ->setName($name)
            ->setPrice($price)
            ->setQty($qty)
            ->setWeight($weight)
            ->setManufacturer($manufacturer)
            ->setDescription($description)
            ->setComposition($composition)
            ->setRef($ref)
            ->setEan($ean)
            ->setHscode($hscode)
            ->setCountry_orig($country_orig)
            ->setPrice_incl_tax($price_incl_tax)
            ->setVat($vat)
            ->setRow_total($row_total)
            ->setRow_total_incl_tax($row_total_incl_tax);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get qty value
     * @return float
     */
    public function getQty()
    {
        return $this->qty;
    }
    /**
     * Set qty value
     * @param float $qty
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setQty($qty = null)
    {
        // validation for constraint: float
        if (!is_null($qty) && !(is_float($qty) || is_numeric($qty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qty, true), gettype($qty)), __LINE__);
        }
        $this->qty = $qty;
        return $this;
    }
    /**
     * Get weight value
     * @return float
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturer, true), gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get composition value
     * @return string|null
     */
    public function getComposition()
    {
        return $this->composition;
    }
    /**
     * Set composition value
     * @param string $composition
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setComposition($composition = null)
    {
        // validation for constraint: string
        if (!is_null($composition) && !is_string($composition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($composition, true), gettype($composition)), __LINE__);
        }
        $this->composition = $composition;
        return $this;
    }
    /**
     * Get ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setRef($ref = null)
    {
        // validation for constraint: string
        if (!is_null($ref) && !is_string($ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ref, true), gettype($ref)), __LINE__);
        }
        $this->ref = $ref;
        return $this;
    }
    /**
     * Get ean value
     * @return string|null
     */
    public function getEan()
    {
        return $this->ean;
    }
    /**
     * Set ean value
     * @param string $ean
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setEan($ean = null)
    {
        // validation for constraint: string
        if (!is_null($ean) && !is_string($ean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ean, true), gettype($ean)), __LINE__);
        }
        $this->ean = $ean;
        return $this;
    }
    /**
     * Get hscode value
     * @return string|null
     */
    public function getHscode()
    {
        return $this->hscode;
    }
    /**
     * Set hscode value
     * @param string $hscode
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setHscode($hscode = null)
    {
        // validation for constraint: string
        if (!is_null($hscode) && !is_string($hscode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hscode, true), gettype($hscode)), __LINE__);
        }
        $this->hscode = $hscode;
        return $this;
    }
    /**
     * Get country_orig value
     * @return string|null
     */
    public function getCountry_orig()
    {
        return $this->country_orig;
    }
    /**
     * Set country_orig value
     * @param string $country_orig
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setCountry_orig($country_orig = null)
    {
        // validation for constraint: string
        if (!is_null($country_orig) && !is_string($country_orig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_orig, true), gettype($country_orig)), __LINE__);
        }
        $this->country_orig = $country_orig;
        return $this;
    }
    /**
     * Get price_incl_tax value
     * @return float|null
     */
    public function getPrice_incl_tax()
    {
        return $this->price_incl_tax;
    }
    /**
     * Set price_incl_tax value
     * @param float $price_incl_tax
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setPrice_incl_tax($price_incl_tax = null)
    {
        // validation for constraint: float
        if (!is_null($price_incl_tax) && !(is_float($price_incl_tax) || is_numeric($price_incl_tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price_incl_tax, true), gettype($price_incl_tax)), __LINE__);
        }
        $this->price_incl_tax = $price_incl_tax;
        return $this;
    }
    /**
     * Get vat value
     * @return float|null
     */
    public function getVat()
    {
        return $this->vat;
    }
    /**
     * Set vat value
     * @param float $vat
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setVat($vat = null)
    {
        // validation for constraint: float
        if (!is_null($vat) && !(is_float($vat) || is_numeric($vat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vat, true), gettype($vat)), __LINE__);
        }
        $this->vat = $vat;
        return $this;
    }
    /**
     * Get row_total value
     * @return float|null
     */
    public function getRow_total()
    {
        return $this->row_total;
    }
    /**
     * Set row_total value
     * @param float $row_total
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setRow_total($row_total = null)
    {
        // validation for constraint: float
        if (!is_null($row_total) && !(is_float($row_total) || is_numeric($row_total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($row_total, true), gettype($row_total)), __LINE__);
        }
        $this->row_total = $row_total;
        return $this;
    }
    /**
     * Get row_total_incl_tax value
     * @return float|null
     */
    public function getRow_total_incl_tax()
    {
        return $this->row_total_incl_tax;
    }
    /**
     * Set row_total_incl_tax value
     * @param float $row_total_incl_tax
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public function setRow_total_incl_tax($row_total_incl_tax = null)
    {
        // validation for constraint: float
        if (!is_null($row_total_incl_tax) && !(is_float($row_total_incl_tax) || is_numeric($row_total_incl_tax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($row_total_incl_tax, true), gettype($row_total_incl_tax)), __LINE__);
        }
        $this->row_total_incl_tax = $row_total_incl_tax;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\ProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
