<?php

namespace Cocorico\EdnBundle\Wsdl;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getQuoteRequest StructType
 * @subpackage Structs
 */
class GetQuoteRequest extends AbstractStructBase
{
    /**
     * The to
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Cocorico\EdnBundle\Wsdl\QuoteAddressType
     */
    public $to;
    /**
     * The ignore_max_weight
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ignore_max_weight;
    /**
     * The do_not_dispatch
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $do_not_dispatch;
    /**
     * The carrier
     * Meta information extracted from the WSDL
     * - documentation: Internal use
     * - hidden: hidden
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $carrier;
    /**
     * The carrier_options
     * Meta information extracted from the WSDL
     * - documentation: Carrier specific options
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Cocorico\EdnBundle\Wsdl\CarrierOptionsType
     */
    public $carrier_options;
    /**
     * The weight
     * Meta information extracted from the WSDL
     * - documentation: Weight of the package in kilograms
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $weight;
    /**
     * The length
     * Meta information extracted from the WSDL
     * - documentation: Length of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $length;
    /**
     * The height
     * Meta information extracted from the WSDL
     * - documentation: Height of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $height;
    /**
     * The width
     * Meta information extracted from the WSDL
     * - documentation: Width of the package in centimeters
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $width;
    /**
     * The pod
     * Meta information extracted from the WSDL
     * - documentation: If a proof of delivery is required
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $pod;
    /**
     * The cod
     * Meta information extracted from the WSDL
     * - documentation: If cash on delivery is required
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $cod;
    /**
     * The insurance
     * Meta information extracted from the WSDL
     * - documentation: Shipment value if you want additional insurance
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $insurance;
    /**
     * The from
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Cocorico\EdnBundle\Wsdl\QuoteAddressType
     */
    public $from;
    /**
     * The packages
     * Meta information extracted from the WSDL
     * - documentation: When requesting a quote for multiple packages, put them here and leave the root-level weight and dimensions empty
     * - arrayType: tns:quotePackageType[]
     * - base: SOAP-ENC:Array
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: SOAP-ENC:arrayType
     * @var \Cocorico\EdnBundle\Wsdl\QuotePackageType[]
     */
    public $packages;
    /**
     * Constructor method for getQuoteRequest
     * @uses GetQuoteRequest::setTo()
     * @uses GetQuoteRequest::setIgnore_max_weight()
     * @uses GetQuoteRequest::setDo_not_dispatch()
     * @uses GetQuoteRequest::setCarrier()
     * @uses GetQuoteRequest::setCarrier_options()
     * @uses GetQuoteRequest::setWeight()
     * @uses GetQuoteRequest::setLength()
     * @uses GetQuoteRequest::setHeight()
     * @uses GetQuoteRequest::setWidth()
     * @uses GetQuoteRequest::setPod()
     * @uses GetQuoteRequest::setCod()
     * @uses GetQuoteRequest::setInsurance()
     * @uses GetQuoteRequest::setFrom()
     * @uses GetQuoteRequest::setPackages()
     * @param \Cocorico\EdnBundle\Wsdl\QuoteAddressType $to
     * @param bool $ignore_max_weight
     * @param bool $do_not_dispatch
     * @param string $carrier
     * @param \Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options
     * @param float $weight
     * @param float $length
     * @param float $height
     * @param float $width
     * @param bool $pod
     * @param bool $cod
     * @param float $insurance
     * @param \Cocorico\EdnBundle\Wsdl\QuoteAddressType $from
     * @param \Cocorico\EdnBundle\Wsdl\QuotePackageType[] $packages
     */
    public function __construct(\Cocorico\EdnBundle\Wsdl\QuoteAddressType $to = null, $ignore_max_weight = null, $do_not_dispatch = null, $carrier = null, \Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options = null, $weight = null, $length = null, $height = null, $width = null, $pod = null, $cod = null, $insurance = null, \Cocorico\EdnBundle\Wsdl\QuoteAddressType $from = null, array $packages = array())
    {
        $this
            ->setTo($to)
            ->setIgnore_max_weight($ignore_max_weight)
            ->setDo_not_dispatch($do_not_dispatch)
            ->setCarrier($carrier)
            ->setCarrier_options($carrier_options)
            ->setWeight($weight)
            ->setLength($length)
            ->setHeight($height)
            ->setWidth($width)
            ->setPod($pod)
            ->setCod($cod)
            ->setInsurance($insurance)
            ->setFrom($from)
            ->setPackages($packages);
    }
    /**
     * Get to value
     * @return \Cocorico\EdnBundle\Wsdl\QuoteAddressType
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param \Cocorico\EdnBundle\Wsdl\QuoteAddressType $to
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setTo(\Cocorico\EdnBundle\Wsdl\QuoteAddressType $to = null)
    {
        $this->to = $to;
        return $this;
    }
    /**
     * Get ignore_max_weight value
     * @return bool|null
     */
    public function getIgnore_max_weight()
    {
        return $this->ignore_max_weight;
    }
    /**
     * Set ignore_max_weight value
     * @param bool $ignore_max_weight
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setIgnore_max_weight($ignore_max_weight = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignore_max_weight) && !is_bool($ignore_max_weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignore_max_weight, true), gettype($ignore_max_weight)), __LINE__);
        }
        $this->ignore_max_weight = $ignore_max_weight;
        return $this;
    }
    /**
     * Get do_not_dispatch value
     * @return bool|null
     */
    public function getDo_not_dispatch()
    {
        return $this->do_not_dispatch;
    }
    /**
     * Set do_not_dispatch value
     * @param bool $do_not_dispatch
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setDo_not_dispatch($do_not_dispatch = null)
    {
        // validation for constraint: boolean
        if (!is_null($do_not_dispatch) && !is_bool($do_not_dispatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($do_not_dispatch, true), gettype($do_not_dispatch)), __LINE__);
        }
        $this->do_not_dispatch = $do_not_dispatch;
        return $this;
    }
    /**
     * Get carrier value
     * @return string|null
     */
    public function getCarrier()
    {
        return $this->carrier;
    }
    /**
     * Set carrier value
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid()
     * @uses \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $carrier
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setCarrier($carrier = null)
    {
        // validation for constraint: enumeration
        if (!\Cocorico\EdnBundle\Wsdl\EnumCarrierType::valueIsValid($carrier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \Cocorico\EdnBundle\Wsdl\EnumCarrierType', is_array($carrier) ? implode(', ', $carrier) : var_export($carrier, true), implode(', ', \Cocorico\EdnBundle\Wsdl\EnumCarrierType::getValidValues())), __LINE__);
        }
        $this->carrier = $carrier;
        return $this;
    }
    /**
     * Get carrier_options value
     * @return \Cocorico\EdnBundle\Wsdl\CarrierOptionsType|null
     */
    public function getCarrier_options()
    {
        return $this->carrier_options;
    }
    /**
     * Set carrier_options value
     * @param \Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setCarrier_options(\Cocorico\EdnBundle\Wsdl\CarrierOptionsType $carrier_options = null)
    {
        $this->carrier_options = $carrier_options;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->length;
    }
    /**
     * Set length value
     * @param float $length
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->length = $length;
        return $this;
    }
    /**
     * Get height value
     * @return float|null
     */
    public function getHeight()
    {
        return $this->height;
    }
    /**
     * Set height value
     * @param float $height
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setHeight($height = null)
    {
        // validation for constraint: float
        if (!is_null($height) && !(is_float($height) || is_numeric($height))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($height, true), gettype($height)), __LINE__);
        }
        $this->height = $height;
        return $this;
    }
    /**
     * Get width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->width;
    }
    /**
     * Set width value
     * @param float $width
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->width = $width;
        return $this;
    }
    /**
     * Get pod value
     * @return bool|null
     */
    public function getPod()
    {
        return $this->pod;
    }
    /**
     * Set pod value
     * @param bool $pod
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setPod($pod = null)
    {
        // validation for constraint: boolean
        if (!is_null($pod) && !is_bool($pod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pod, true), gettype($pod)), __LINE__);
        }
        $this->pod = $pod;
        return $this;
    }
    /**
     * Get cod value
     * @return bool|null
     */
    public function getCod()
    {
        return $this->cod;
    }
    /**
     * Set cod value
     * @param bool $cod
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setCod($cod = null)
    {
        // validation for constraint: boolean
        if (!is_null($cod) && !is_bool($cod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cod, true), gettype($cod)), __LINE__);
        }
        $this->cod = $cod;
        return $this;
    }
    /**
     * Get insurance value
     * @return float|null
     */
    public function getInsurance()
    {
        return $this->insurance;
    }
    /**
     * Set insurance value
     * @param float $insurance
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setInsurance($insurance = null)
    {
        // validation for constraint: float
        if (!is_null($insurance) && !(is_float($insurance) || is_numeric($insurance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insurance, true), gettype($insurance)), __LINE__);
        }
        $this->insurance = $insurance;
        return $this;
    }
    /**
     * Get from value
     * @return \Cocorico\EdnBundle\Wsdl\QuoteAddressType|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \Cocorico\EdnBundle\Wsdl\QuoteAddressType $from
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setFrom(\Cocorico\EdnBundle\Wsdl\QuoteAddressType $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get packages value
     * @return \Cocorico\EdnBundle\Wsdl\QuotePackageType[]|null
     */
    public function getPackages()
    {
        return $this->packages;
    }
    /**
     * This method is responsible for validating the values passed to the setPackages method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackages method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackagesForArrayConstraintsFromSetPackages(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getQuoteRequestPackagesItem) {
            // validation for constraint: itemType
            if (!$getQuoteRequestPackagesItem instanceof \Cocorico\EdnBundle\Wsdl\QuotePackageType) {
                $invalidValues[] = is_object($getQuoteRequestPackagesItem) ? get_class($getQuoteRequestPackagesItem) : sprintf('%s(%s)', gettype($getQuoteRequestPackagesItem), var_export($getQuoteRequestPackagesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The packages property can only contain items of type \Cocorico\EdnBundle\Wsdl\QuotePackageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set packages value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\QuotePackageType[] $packages
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function setPackages(array $packages = array())
    {
        // validation for constraint: array
        if ('' !== ($packagesArrayErrorMessage = self::validatePackagesForArrayConstraintsFromSetPackages($packages))) {
            throw new \InvalidArgumentException($packagesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($packages) && count($packages) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 1', count($packages)), __LINE__);
        }
        $this->packages = $packages;
        return $this;
    }
    /**
     * Add item to packages value
     * @throws \InvalidArgumentException
     * @param \Cocorico\EdnBundle\Wsdl\QuotePackageType $item
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public function addToPackages(\Cocorico\EdnBundle\Wsdl\QuotePackageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Cocorico\EdnBundle\Wsdl\QuotePackageType) {
            throw new \InvalidArgumentException(sprintf('The packages property can only contain items of type \Cocorico\EdnBundle\Wsdl\QuotePackageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(1)
        if (is_array($this->packages) && count($this->packages) >= 1) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 1', count($this->packages)), __LINE__);
        }
        $this->packages[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Cocorico\EdnBundle\Wsdl\GetQuoteRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
